/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.json.schema.common.NoopValidatorContext;
import io.vertx.json.schema.common.ValidatorContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RecordingValidatorContext
implements ValidatorContext {
    private final ValidatorContext parent;
    private final String inputKey;
    private Set<Integer> evaluatedItems;
    private Set<String> evaluatedProperties;

    public RecordingValidatorContext(ValidatorContext parent, String key) {
        this.parent = parent;
        this.inputKey = key;
    }

    @Override
    public ValidatorContext startRecording() {
        return this;
    }

    @Override
    public void markEvaluatedItem(int index) {
        if (this.evaluatedItems == null) {
            this.evaluatedItems = new HashSet<Integer>();
        }
        this.evaluatedItems.add(index);
    }

    @Override
    public void markEvaluatedProperty(String propertyName) {
        if (this.evaluatedProperties == null) {
            this.evaluatedProperties = new HashSet<String>();
        }
        this.evaluatedProperties.add(propertyName);
    }

    @Override
    public Set<Integer> evaluatedItems() {
        return this.evaluatedItems != null ? this.evaluatedItems : Collections.emptySet();
    }

    @Override
    public Set<String> evaluatedProperties() {
        return this.evaluatedProperties != null ? this.evaluatedProperties : Collections.emptySet();
    }

    @Override
    public ValidatorContext lowerLevelContext(String key) {
        return new NoopValidatorContext(this, key);
    }

    @Override
    public ValidatorContext lowerLevelContext(int key) {
        return new NoopValidatorContext(this, Integer.toString(key));
    }

    @Override
    public ValidatorContext parent() {
        return this.parent;
    }

    @Override
    public String inputKey() {
        return this.inputKey;
    }
}

