/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.impl.JsonArrayProxy;
import io.vertx.json.schema.impl.JsonObjectProxy;
import io.vertx.json.schema.impl.JsonObjectRef;
import io.vertx.json.schema.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JsonRef {
    public static final List<String> POINTER_KEYWORD = Arrays.asList("$ref", "$id", "$anchor", "$dynamicRef", "$dynamicAnchor", "$schema");
    final String ref;
    final JsonObject obj;
    final String prop;
    final String path;
    final String id;

    private JsonRef(String ref, JsonObject obj, String prop, String path, String id) {
        this.ref = ref;
        this.obj = obj;
        this.prop = prop;
        this.path = path;
        this.id = id;
    }

    public static JsonObject resolve(JsonObject schema) {
        return JsonRef.resolve(schema, Collections.emptyMap());
    }

    private static <T> T copy(T o) {
        if (o instanceof JsonObject) {
            JsonObject obj = (JsonObject)o;
            JsonObjectProxy ret = new JsonObjectProxy();
            for (Map.Entry child : obj) {
                ret.put((String)child.getKey(), JsonRef.copy(child.getValue()));
            }
            return (T)ret;
        }
        if (o instanceof JsonArray) {
            JsonArray obj = (JsonArray)o;
            JsonArrayProxy ret = new JsonArrayProxy();
            for (Object elt : obj) {
                ret.add(JsonRef.copy(elt));
            }
            return (T)ret;
        }
        return o;
    }

    public static JsonObject resolve(JsonObject schema, Map<String, JsonSchema> lookup) {
        String fullRef;
        JsonObject obj;
        String path;
        String ref;
        if (!Utils.Objects.isObject(schema)) {
            return null;
        }
        JsonObject tree = JsonRef.copy(schema);
        HashMap<String, List<JsonRef>> pointers = new HashMap<String, List<JsonRef>>();
        JsonRef.parse(tree, "#", "", pointers);
        HashMap<String, JsonObject> anchors = new HashMap<String, JsonObject>();
        anchors.put("", tree);
        HashMap<String, JsonObject> dynamicAnchors = new HashMap<String, JsonObject>();
        for (JsonRef item : pointers.computeIfAbsent("$id", key -> Collections.emptyList())) {
            ref = item.ref;
            path = item.path;
            obj = item.obj;
            if (anchors.containsKey(ref)) {
                throw new IllegalStateException("$id: '" + ref + "' defined more than once at: " + path);
            }
            anchors.put(ref, obj);
        }
        for (JsonRef item : pointers.computeIfAbsent("$anchor", key -> Collections.emptyList())) {
            ref = item.ref;
            path = item.path;
            obj = item.obj;
            String id = item.id;
            fullRef = id + "#" + ref;
            if (anchors.containsKey(fullRef)) {
                throw new IllegalStateException("$anchor: '" + ref + "' defined more than once at: " + path);
            }
            anchors.put(fullRef, obj);
        }
        for (JsonRef item : pointers.computeIfAbsent("$dynamicAnchor", key -> Collections.emptyList())) {
            ref = item.ref;
            path = item.path;
            obj = item.obj;
            if (dynamicAnchors.containsKey("#" + ref)) {
                throw new IllegalStateException("$dynamicAnchor: '" + ref + "' defined more than once at: " + path);
            }
            dynamicAnchors.put("#" + ref, obj);
        }
        for (JsonRef item : pointers.computeIfAbsent("$ref", key -> Collections.emptyList())) {
            ref = item.ref;
            String id = item.id;
            String path2 = item.path;
            String decodedRef = URIDecoder.decodeURIComponent((String)ref);
            fullRef = decodedRef.charAt(0) != '#' ? decodedRef : id + decodedRef;
            tree = JsonRef.applyRef(tree, path2, JsonRef.resolveUri(fullRef, anchors, lookup));
        }
        for (JsonRef item : pointers.computeIfAbsent("$dynamicRef", key -> Collections.emptyList())) {
            ref = item.ref;
            path = item.path;
            if (!dynamicAnchors.containsKey(ref)) {
                throw new IllegalStateException("Can't resolve $dynamicAnchor: '" + ref + "'");
            }
            tree = JsonRef.applyRef(tree, path, (JsonObject)dynamicAnchors.get(ref));
        }
        return tree;
    }

    private static void parse(Object obj, String path, String id, Map<String, List<JsonRef>> pointers) {
        JsonArray json;
        if (!Utils.Objects.isObject(obj)) {
            return;
        }
        if (obj instanceof JsonArray) {
            json = (JsonArray)obj;
            for (int i = 0; i < json.size(); ++i) {
                JsonRef.parse(json.getValue(i), path + "/" + i, id, pointers);
            }
        }
        if (obj instanceof JsonObject) {
            json = (JsonObject)obj;
            if (json.containsKey("$id")) {
                id = json.getString("$id");
            }
            Iterator iterator = json.fieldNames().iterator();
            block9: while (iterator.hasNext()) {
                String prop;
                switch (prop = (String)iterator.next()) {
                    case "__absolute_uri__": 
                    case "__absolute_ref__": 
                    case "__absolute_recursive_ref__": {
                        continue block9;
                    }
                }
                if (POINTER_KEYWORD.contains(prop)) {
                    pointers.computeIfAbsent(prop, key -> new ArrayList()).add(new JsonRef(json.getString(prop), (JsonObject)json, prop, path, id));
                    iterator.remove();
                }
                JsonRef.parse(json.getValue(prop), path + "/" + Utils.Pointers.escape(prop), id, pointers);
            }
        }
    }

    private static JsonObject applyRef(JsonObject tree, String path, JsonObject target) {
        Object root = tree;
        String[] paths = path.split("/");
        if (paths.length > 1) {
            String prop = paths[paths.length - 1];
            for (int i = 1; i < paths.length - 1; ++i) {
                String p = paths[i];
                if (root instanceof JsonArray) {
                    root = ((JsonArray)root).getValue(Integer.parseInt(p));
                    continue;
                }
                if (!(root instanceof JsonObject)) continue;
                root = root.getValue(Utils.Pointers.unescape(p));
            }
            if (root instanceof JsonArray) {
                ((JsonArray)root).set(Integer.parseInt(prop), (Object)new JsonObjectRef(target));
            } else if (root instanceof JsonObject) {
                root.put(Utils.Pointers.unescape(prop), (Object)new JsonObjectRef(target));
            }
            return tree;
        }
        return target;
    }

    private static JsonObject resolveUri(String uri, Map<String, JsonObject> anchors, Map<String, JsonSchema> lookup) {
        String path;
        String[] parts = uri.split("#", 2);
        boolean hashPresent = parts.length == 2 && parts[1] != null;
        String prefix = parts[0];
        String string = path = hashPresent ? parts[1] : null;
        if (hashPresent && path.charAt(0) != '/') {
            if (anchors.containsKey(uri)) {
                return anchors.get(uri);
            }
            throw new UnsupportedOperationException("Can't resolve '" + uri + "', only internal refs are supported.");
        }
        if (!anchors.containsKey(prefix)) {
            if (lookup.containsKey(prefix)) {
                if (!hashPresent) {
                    return JsonRef.resolve((JsonObject)lookup.get(prefix), lookup);
                }
                return JsonRef.reduce(path, JsonRef.resolve((JsonObject)lookup.get(prefix), lookup));
            }
            throw new UnsupportedOperationException("Can't resolve '" + uri + "', only internal refs are supported.");
        }
        if (!hashPresent) {
            return anchors.get(prefix);
        }
        return JsonRef.reduce(path, anchors.get(prefix));
    }

    private static JsonObject reduce(String path, JsonObject initialValue) {
        String[] paths = path.split("/");
        JsonObject accumulator = initialValue;
        for (int i = 1; i < paths.length; ++i) {
            String currentValue = Utils.Pointers.unescape(paths[i]);
            if (!accumulator.containsKey(currentValue)) {
                throw new IllegalStateException("Can't reduce [" + i + "] '" + path + "', value is undefined.");
            }
            accumulator = accumulator.getJsonObject(currentValue);
        }
        return accumulator;
    }
}

