/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.core.net

import io.vertx.core.net.JdkSSLEngineOptions

/**
 * A function providing a DSL for building [io.vertx.core.net.JdkSSLEngineOptions] objects.
 *
 * Configures a [io.vertx.core.net.TCPSSLOptions] to use the JDK ssl engine implementation.
 *
 *
 * <p/>
 * NOTE: This function has been automatically generated from the [io.vertx.core.net.JdkSSLEngineOptions original] using Vert.x codegen.
 */
fun jdkSSLEngineOptionsOf(
): JdkSSLEngineOptions = io.vertx.core.net.JdkSSLEngineOptions().apply {

}

/**
 * A function providing a DSL for building [io.vertx.core.net.JdkSSLEngineOptions] objects.
 *
 * Configures a [io.vertx.core.net.TCPSSLOptions] to use the JDK ssl engine implementation.
 *
 *
 * <p/>
 * NOTE: This function has been automatically generated from the [io.vertx.core.net.JdkSSLEngineOptions original] using Vert.x codegen.
 */
@Deprecated(
  message = "This function will be removed in a future version",
  replaceWith = ReplaceWith("jdkSSLEngineOptionsOf()")
)
fun JdkSSLEngineOptions(
): JdkSSLEngineOptions = io.vertx.core.net.JdkSSLEngineOptions().apply {

}

