/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.ext.sql

import io.vertx.ext.sql.SQLOptions
import io.vertx.ext.sql.FetchDirection
import io.vertx.ext.sql.ResultSetConcurrency
import io.vertx.ext.sql.ResultSetType
import io.vertx.ext.sql.TransactionIsolation

/**
 * A function providing a DSL for building [io.vertx.ext.sql.SQLOptions] objects.
 *
 * Represents the options one can use to customize the unwrapped connection/statement/resultset types
 *
 * @param autoGeneratedKeys 
 * @param autoGeneratedKeysIndexes 
 * @param catalog 
 * @param fetchDirection 
 * @param fetchSize 
 * @param maxRows 
 * @param queryTimeout 
 * @param readOnly 
 * @param resultSetConcurrency 
 * @param resultSetType 
 * @param schema 
 * @param transactionIsolation 
 *
 * <p/>
 * NOTE: This function has been automatically generated from the [io.vertx.ext.sql.SQLOptions original] using Vert.x codegen.
 */
fun sqlOptionsOf(
  autoGeneratedKeys: Boolean? = null,
  autoGeneratedKeysIndexes: io.vertx.core.json.JsonArray? = null,
  catalog: String? = null,
  fetchDirection: FetchDirection? = null,
  fetchSize: Int? = null,
  maxRows: Int? = null,
  queryTimeout: Int? = null,
  readOnly: Boolean? = null,
  resultSetConcurrency: ResultSetConcurrency? = null,
  resultSetType: ResultSetType? = null,
  schema: String? = null,
  transactionIsolation: TransactionIsolation? = null): SQLOptions = io.vertx.ext.sql.SQLOptions().apply {

  if (autoGeneratedKeys != null) {
    this.setAutoGeneratedKeys(autoGeneratedKeys)
  }
  if (autoGeneratedKeysIndexes != null) {
    this.setAutoGeneratedKeysIndexes(autoGeneratedKeysIndexes)
  }
  if (catalog != null) {
    this.setCatalog(catalog)
  }
  if (fetchDirection != null) {
    this.setFetchDirection(fetchDirection)
  }
  if (fetchSize != null) {
    this.setFetchSize(fetchSize)
  }
  if (maxRows != null) {
    this.setMaxRows(maxRows)
  }
  if (queryTimeout != null) {
    this.setQueryTimeout(queryTimeout)
  }
  if (readOnly != null) {
    this.setReadOnly(readOnly)
  }
  if (resultSetConcurrency != null) {
    this.setResultSetConcurrency(resultSetConcurrency)
  }
  if (resultSetType != null) {
    this.setResultSetType(resultSetType)
  }
  if (schema != null) {
    this.setSchema(schema)
  }
  if (transactionIsolation != null) {
    this.setTransactionIsolation(transactionIsolation)
  }
}

/**
 * A function providing a DSL for building [io.vertx.ext.sql.SQLOptions] objects.
 *
 * Represents the options one can use to customize the unwrapped connection/statement/resultset types
 *
 * @param autoGeneratedKeys 
 * @param autoGeneratedKeysIndexes 
 * @param catalog 
 * @param fetchDirection 
 * @param fetchSize 
 * @param maxRows 
 * @param queryTimeout 
 * @param readOnly 
 * @param resultSetConcurrency 
 * @param resultSetType 
 * @param schema 
 * @param transactionIsolation 
 *
 * <p/>
 * NOTE: This function has been automatically generated from the [io.vertx.ext.sql.SQLOptions original] using Vert.x codegen.
 */
@Deprecated(
  message = "This function will be removed in a future version",
  replaceWith = ReplaceWith("sqlOptionsOf(autoGeneratedKeys, autoGeneratedKeysIndexes, catalog, fetchDirection, fetchSize, maxRows, queryTimeout, readOnly, resultSetConcurrency, resultSetType, schema, transactionIsolation)")
)
fun SQLOptions(
  autoGeneratedKeys: Boolean? = null,
  autoGeneratedKeysIndexes: io.vertx.core.json.JsonArray? = null,
  catalog: String? = null,
  fetchDirection: FetchDirection? = null,
  fetchSize: Int? = null,
  maxRows: Int? = null,
  queryTimeout: Int? = null,
  readOnly: Boolean? = null,
  resultSetConcurrency: ResultSetConcurrency? = null,
  resultSetType: ResultSetType? = null,
  schema: String? = null,
  transactionIsolation: TransactionIsolation? = null): SQLOptions = io.vertx.ext.sql.SQLOptions().apply {

  if (autoGeneratedKeys != null) {
    this.setAutoGeneratedKeys(autoGeneratedKeys)
  }
  if (autoGeneratedKeysIndexes != null) {
    this.setAutoGeneratedKeysIndexes(autoGeneratedKeysIndexes)
  }
  if (catalog != null) {
    this.setCatalog(catalog)
  }
  if (fetchDirection != null) {
    this.setFetchDirection(fetchDirection)
  }
  if (fetchSize != null) {
    this.setFetchSize(fetchSize)
  }
  if (maxRows != null) {
    this.setMaxRows(maxRows)
  }
  if (queryTimeout != null) {
    this.setQueryTimeout(queryTimeout)
  }
  if (readOnly != null) {
    this.setReadOnly(readOnly)
  }
  if (resultSetConcurrency != null) {
    this.setResultSetConcurrency(resultSetConcurrency)
  }
  if (resultSetType != null) {
    this.setResultSetType(resultSetType)
  }
  if (schema != null) {
    this.setSchema(schema)
  }
  if (transactionIsolation != null) {
    this.setTransactionIsolation(transactionIsolation)
  }
}

