/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.ValidationOptions;
import java.util.Base64;
import java.util.Map;

public class CreateCollectionOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, CreateCollectionOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "capped": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCapped((Boolean)member.getValue());
                    break;
                }
                case "collation": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCollation(new CollationOptions((JsonObject)member.getValue()));
                    break;
                }
                case "indexOptionDefaults": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setIndexOptionDefaults(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "maxDocuments": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxDocuments(((Number)member.getValue()).longValue());
                    break;
                }
                case "sizeInBytes": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSizeInBytes(((Number)member.getValue()).longValue());
                    break;
                }
                case "storageEngineOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setStorageEngineOptions(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "validationOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setValidationOptions(new ValidationOptions((JsonObject)member.getValue()));
                }
            }
        }
    }

    public static void toJson(CreateCollectionOptions obj, JsonObject json) {
        CreateCollectionOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(CreateCollectionOptions obj, Map<String, Object> json) {
        if (obj.getCapped() != null) {
            json.put("capped", obj.getCapped());
        }
        if (obj.getCollation() != null) {
            json.put("collation", obj.getCollation().toJson());
        }
        if (obj.getIndexOptionDefaults() != null) {
            json.put("indexOptionDefaults", obj.getIndexOptionDefaults());
        }
        if (obj.getMaxDocuments() != null) {
            json.put("maxDocuments", obj.getMaxDocuments());
        }
        if (obj.getSizeInBytes() != null) {
            json.put("sizeInBytes", obj.getSizeInBytes());
        }
        if (obj.getStorageEngineOptions() != null) {
            json.put("storageEngineOptions", obj.getStorageEngineOptions());
        }
        if (obj.getValidationOptions() != null) {
            json.put("validationOptions", obj.getValidationOptions().toJson());
        }
    }
}

