/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class ClusterSettingsParser {
    private final ClusterSettings settings;

    public ClusterSettingsParser(ConnectionString connectionString, JsonObject config) {
        Long serverSelectionTimeoutMS;
        List<ServerAddress> hosts;
        ClusterSettings.Builder settings = ClusterSettings.builder();
        if (connectionString != null) {
            settings.applyConnectionString(connectionString);
        }
        if (!(hosts = ClusterSettingsParser.parseHosts(connectionString, config)).isEmpty()) {
            settings.hosts(hosts);
            String replicaSet = config.getString("replicaSet");
            if (hosts.size() == 1 && replicaSet == null) {
                settings.mode(ClusterConnectionMode.SINGLE);
            } else {
                settings.mode(ClusterConnectionMode.MULTIPLE);
            }
            if (replicaSet != null) {
                settings.requiredReplicaSetName(replicaSet);
            }
        }
        if ((serverSelectionTimeoutMS = config.getLong("serverSelectionTimeoutMS")) != null) {
            settings.serverSelectionTimeout(serverSelectionTimeoutMS.longValue(), TimeUnit.MILLISECONDS);
        }
        this.settings = settings.build();
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    private static List<ServerAddress> parseHosts(ConnectionString connectionString, JsonObject config) {
        ArrayList<ServerAddress> hosts = new ArrayList<ServerAddress>();
        JsonArray jsonHosts = config.getJsonArray("hosts");
        if (jsonHosts != null) {
            for (Object jsonHost : jsonHosts) {
                ServerAddress address = ClusterSettingsParser.serverAddress((JsonObject)jsonHost);
                if (address == null) continue;
                hosts.add(address);
            }
        } else {
            ServerAddress address = ClusterSettingsParser.serverAddress(config);
            if (address != null) {
                hosts.add(address);
            }
        }
        if (hosts.isEmpty() && connectionString == null) {
            hosts.add(new ServerAddress());
        }
        return hosts;
    }

    private static ServerAddress serverAddress(JsonObject json) {
        if (json == null) {
            return null;
        }
        String host = json.getString("host");
        Integer port = json.getInteger("port");
        if (host == null) {
            return null;
        }
        if (port == null) {
            return new ServerAddress(host);
        }
        return new ServerAddress(host, port.intValue());
    }
}

