/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.connection.ServerSettings;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

class ServerSettingsParser {
    private final ServerSettings settings;

    public ServerSettingsParser(JsonObject config) {
        Long minHeartbeatFrequencyMS;
        ServerSettings.Builder settings = ServerSettings.builder();
        Long heartbeatFrequencyMS = config.getLong("heartbeatFrequencyMS");
        if (heartbeatFrequencyMS != null) {
            settings.heartbeatFrequency(heartbeatFrequencyMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((minHeartbeatFrequencyMS = config.getLong("minHeartbeatFrequencyMS")) != null) {
            settings.minHeartbeatFrequency(minHeartbeatFrequencyMS.longValue(), TimeUnit.MILLISECONDS);
        }
        this.settings = settings.build();
    }

    public ServerSettings settings() {
        return this.settings;
    }
}

