/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import io.vertx.core.Promise;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class BufferingSubscriber<T>
implements Subscriber<T> {
    private final List<T> received = new ArrayList<T>();
    private final Promise<List<T>> promise;

    BufferingSubscriber(Promise<List<T>> promise) {
        Objects.requireNonNull(promise, "promise is null");
        this.promise = promise;
    }

    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        this.received.add(t);
    }

    public void onError(Throwable t) {
        this.promise.fail(t);
    }

    public void onComplete() {
        this.promise.complete(this.received);
    }
}

