/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.connection.SslSettings;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.impl.TrustAllTrustManager;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

class SSLSettingsParser {
    private static final Logger log = LoggerFactory.getLogger(SSLSettingsParser.class);
    private final ConnectionString connectionString;
    private final JsonObject config;

    SSLSettingsParser(ConnectionString connectionString, JsonObject config) {
        this.connectionString = connectionString;
        this.config = config;
    }

    public SslSettings settings(Vertx vertx) {
        SslSettings.Builder builder = SslSettings.builder();
        this.fromConnectionString(builder);
        this.fromConfiguration(builder);
        SslSettings settings = builder.build();
        if (!settings.isEnabled()) {
            return settings;
        }
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions();
        PemTrustOptions pemTrustOptions = new PemTrustOptions();
        if (this.config.containsKey("caPath")) {
            pemTrustOptions.addCertPath(this.config.getString("caPath"));
        }
        if (this.config.containsKey("keyPath") && this.config.containsKey("certPath")) {
            pemKeyCertOptions.addKeyPath(this.config.getString("keyPath"));
            pemKeyCertOptions.addCertPath(this.config.getString("certPath"));
        }
        try {
            TrustManager[] tms;
            if (this.config.getBoolean("trustAll", Boolean.valueOf(false)).booleanValue()) {
                log.warn((Object)"Mongo client has been set to trust ALL certificates, this can open you up to security issues. Make sure you know the risks.");
                tms = new TrustManager[]{TrustAllTrustManager.INSTANCE};
            } else {
                tms = !pemTrustOptions.getCertPaths().isEmpty() ? pemTrustOptions.getTrustManagerFactory(vertx).getTrustManagers() : null;
            }
            SSLContext context = SSLContext.getInstance("TLS");
            KeyManager[] mgr = pemKeyCertOptions.getKeyManagerFactory(vertx).getKeyManagers();
            context.init(mgr, tms, new SecureRandom());
            builder.context(context);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return builder.build();
    }

    private void fromConnectionString(SslSettings.Builder builder) {
        if (this.connectionString != null) {
            builder.applyConnectionString(this.connectionString);
        }
    }

    private void fromConfiguration(SslSettings.Builder builder) {
        if (this.config.containsKey("ssl")) {
            builder.enabled(this.config.getBoolean("ssl", Boolean.valueOf(false)).booleanValue());
        }
        if (this.config.containsKey("sslInvalidHostNameAllowed")) {
            builder.invalidHostNameAllowed(this.config.getBoolean("sslInvalidHostNameAllowed", Boolean.valueOf(false)).booleanValue());
        }
    }
}

