/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.MqttConnectionException;
import io.vertx.mqtt.MqttException;
import io.vertx.mqtt.messages.MqttConnAckMessage;
import io.vertx.mqtt.messages.MqttMessage;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MqttClientImpl
implements MqttClient {
    private static final Pattern validTopicNamePattern = Pattern.compile("^[^#+\\u0000]+$");
    private static final Pattern validTopicFilterPattern = Pattern.compile("^(#|((\\+(?![^/]))?([^#+]*(/\\+(?![^/]))?)*(/#)?))$");
    private static final Logger log = LoggerFactory.getLogger(MqttClientImpl.class);
    private static final int MAX_MESSAGE_ID = 65535;
    private static final int MAX_TOPIC_LEN = 65535;
    private static final int MIN_TOPIC_LEN = 1;
    private static final String PROTOCOL_NAME = "MQTT";
    private static final int PROTOCOL_VERSION = 4;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private final MqttClientOptions options;
    private final NetClient client;
    private NetSocketInternal connection;
    private Context ctx;
    private Handler<Integer> publishCompletionHandler;
    private Handler<Integer> unsubscribeCompletionHandler;
    private Handler<io.vertx.mqtt.messages.MqttPublishMessage> publishHandler;
    private Handler<io.vertx.mqtt.messages.MqttSubAckMessage> subscribeCompletionHandler;
    private Handler<AsyncResult<MqttConnAckMessage>> connectHandler;
    private Handler<Void> pingrespHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private HashMap<Integer, io.netty.handler.codec.mqtt.MqttMessage> qos1outbound = new HashMap();
    private HashMap<Integer, io.netty.handler.codec.mqtt.MqttMessage> qos2outbound = new HashMap();
    private HashMap<Integer, MqttMessage> qos2inbound = new HashMap();
    private int messageIdCounter;
    private int countInflightQueue;
    private boolean isConnected;

    public MqttClientImpl(Vertx vertx, MqttClientOptions options) {
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        netClientOptions.setIdleTimeout(0);
        this.client = vertx.createNetClient(netClientOptions);
        this.options = options;
    }

    @Override
    public MqttClient connect(int port, String host, Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.doConnect(port, host, null, connectHandler);
        return this;
    }

    @Override
    public MqttClient connect(int port, String host, String serverName, Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.doConnect(port, host, serverName, connectHandler);
        return this;
    }

    private void doConnect(int port, String host, String serverName, Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        log.debug((Object)String.format("Trying to connect with %s:%d", host, port));
        this.client.connect(port, host, serverName, done -> {
            if (done.failed()) {
                log.error((Object)String.format("Can't connect to %s:%d", host, port), done.cause());
                if (connectHandler != null) {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)done.cause()));
                }
            } else {
                log.info((Object)String.format("Connection with %s:%d established successfully", host, port));
                NetSocketInternal soi = (NetSocketInternal)done.result();
                ChannelPipeline pipeline = soi.channelHandlerContext().pipeline();
                this.connectHandler = connectHandler;
                if (this.options.isAutoGeneratedClientId() && (this.options.getClientId() == null || this.options.getClientId().isEmpty())) {
                    this.options.setClientId(this.generateRandomClientId());
                }
                this.initChannel(pipeline);
                this.connection = soi;
                this.ctx = Vertx.currentContext();
                soi.messageHandler(msg -> this.handleMessage(soi.channelHandlerContext(), msg));
                soi.closeHandler(v -> this.handleClosed());
                soi.exceptionHandler(this::handleException);
                MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.CONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
                MqttConnectVariableHeader variableHeader = new MqttConnectVariableHeader(PROTOCOL_NAME, 4, this.options.hasUsername(), this.options.hasPassword(), this.options.isWillRetain(), this.options.getWillQoS(), this.options.isWillFlag(), this.options.isCleanSession(), this.options.getKeepAliveTimeSeconds());
                MqttConnectPayload payload = new MqttConnectPayload(this.options.getClientId() == null ? "" : this.options.getClientId(), this.options.getWillTopic(), this.options.getWillMessage() != null ? this.options.getWillMessage().getBytes(StandardCharsets.UTF_8) : null, this.options.hasUsername() ? this.options.getUsername() : null, this.options.hasPassword() ? this.options.getPassword().getBytes() : null);
                io.netty.handler.codec.mqtt.MqttMessage connect = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
                this.write(connect);
            }
        });
    }

    @Override
    public MqttClient disconnect() {
        return this.disconnect(null);
    }

    @Override
    public MqttClient disconnect(Handler<AsyncResult<Void>> disconnectHandler) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.DISCONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
        io.netty.handler.codec.mqtt.MqttMessage disconnect = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, null, null);
        this.write(disconnect);
        if (disconnectHandler != null) {
            disconnectHandler.handle((Object)Future.succeededFuture());
        }
        this.connection().close();
        return this;
    }

    @Override
    public MqttClient publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return this.publish(topic, payload, qosLevel, isDup, isRetain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttClient publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) {
        io.netty.handler.codec.mqtt.MqttMessage publish;
        MqttPublishVariableHeader variableHeader;
        MqttClientImpl mqttClientImpl = this;
        synchronized (mqttClientImpl) {
            if (this.countInflightQueue >= this.options.getMaxInflightQueue()) {
                String msg = String.format("Attempt to exceed the limit of %d inflight messages", this.options.getMaxInflightQueue());
                log.error((Object)msg);
                MqttException exception = new MqttException(2, msg);
                if (publishSentHandler != null) {
                    this.ctx.runOnContext(v -> publishSentHandler.handle((Object)Future.failedFuture((Throwable)exception)));
                }
                return this;
            }
            if (!this.isValidTopicName(topic)) {
                String msg = String.format("Invalid Topic Name - %s. It mustn't contains wildcards: # and +. Also it can't contains U+0000(NULL) chars", topic);
                log.error((Object)msg);
                MqttException exception = new MqttException(0, msg);
                if (publishSentHandler != null) {
                    this.ctx.runOnContext(v -> publishSentHandler.handle((Object)Future.failedFuture((Throwable)exception)));
                }
                return this;
            }
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, isDup, qosLevel, isRetain, 0);
            ByteBuf buf = Unpooled.copiedBuffer((byte[])payload.getBytes());
            variableHeader = new MqttPublishVariableHeader(topic, this.nextMessageId());
            publish = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)buf);
            switch (qosLevel) {
                case AT_LEAST_ONCE: {
                    this.qos1outbound.put(variableHeader.packetId(), publish);
                    ++this.countInflightQueue;
                    break;
                }
                case EXACTLY_ONCE: {
                    this.qos2outbound.put(variableHeader.packetId(), publish);
                    ++this.countInflightQueue;
                }
            }
        }
        this.write(publish);
        if (publishSentHandler != null) {
            publishSentHandler.handle((Object)Future.succeededFuture((Object)variableHeader.packetId()));
        }
        return this;
    }

    @Override
    public MqttClient publishCompletionHandler(Handler<Integer> publishCompletionHandler) {
        this.publishCompletionHandler = publishCompletionHandler;
        return this;
    }

    private synchronized Handler<Integer> publishCompletionHandler() {
        return this.publishCompletionHandler;
    }

    @Override
    public MqttClient publishHandler(Handler<io.vertx.mqtt.messages.MqttPublishMessage> publishHandler) {
        this.publishHandler = publishHandler;
        return this;
    }

    private synchronized Handler<io.vertx.mqtt.messages.MqttPublishMessage> publishHandler() {
        return this.publishHandler;
    }

    @Override
    public MqttClient subscribeCompletionHandler(Handler<io.vertx.mqtt.messages.MqttSubAckMessage> subscribeCompletionHandler) {
        this.subscribeCompletionHandler = subscribeCompletionHandler;
        return this;
    }

    private synchronized Handler<io.vertx.mqtt.messages.MqttSubAckMessage> subscribeCompletionHandler() {
        return this.subscribeCompletionHandler;
    }

    @Override
    public MqttClient subscribe(String topic, int qos) {
        return this.subscribe(topic, qos, null);
    }

    @Override
    public MqttClient subscribe(String topic, int qos, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        return this.subscribe(Collections.singletonMap(topic, qos), subscribeSentHandler);
    }

    @Override
    public MqttClient subscribe(Map<String, Integer> topics) {
        return this.subscribe(topics, null);
    }

    @Override
    public MqttClient subscribe(Map<String, Integer> topics, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        Map<String, Integer> invalidTopics = topics.entrySet().stream().filter(e -> !this.isValidTopicFilter((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (invalidTopics.size() > 0) {
            String msg = String.format("Invalid Topic Filters: %s", invalidTopics);
            log.error((Object)msg);
            MqttException exception = new MqttException(1, msg);
            if (subscribeSentHandler != null) {
                subscribeSentHandler.handle((Object)Future.failedFuture((Throwable)exception));
            }
            return this;
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)this.nextMessageId());
        List subscriptions = topics.entrySet().stream().map(e -> new MqttTopicSubscription((String)e.getKey(), MqttQoS.valueOf((int)((Integer)e.getValue())))).collect(Collectors.toList());
        MqttSubscribePayload payload = new MqttSubscribePayload(subscriptions);
        io.netty.handler.codec.mqtt.MqttMessage subscribe = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        this.write(subscribe);
        if (subscribeSentHandler != null) {
            subscribeSentHandler.handle((Object)Future.succeededFuture((Object)variableHeader.messageId()));
        }
        return this;
    }

    @Override
    public MqttClient unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) {
        this.unsubscribeCompletionHandler = unsubscribeCompletionHandler;
        return this;
    }

    private synchronized Handler<Integer> unsubscribeCompletionHandler() {
        return this.unsubscribeCompletionHandler;
    }

    @Override
    public MqttClient unsubscribe(String topic, Handler<AsyncResult<Integer>> unsubscribeSentHandler) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)this.nextMessageId());
        MqttUnsubscribePayload payload = new MqttUnsubscribePayload(Stream.of(topic).collect(Collectors.toList()));
        io.netty.handler.codec.mqtt.MqttMessage unsubscribe = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        this.write(unsubscribe);
        if (unsubscribeSentHandler != null) {
            unsubscribeSentHandler.handle((Object)Future.succeededFuture((Object)variableHeader.messageId()));
        }
        return this;
    }

    private synchronized Handler<AsyncResult<MqttConnAckMessage>> connectHandler() {
        return this.connectHandler;
    }

    @Override
    public MqttClient unsubscribe(String topic) {
        return this.unsubscribe(topic, null);
    }

    @Override
    public synchronized MqttClient pingResponseHandler(Handler<Void> pingResponseHandler) {
        this.pingrespHandler = pingResponseHandler;
        return this;
    }

    private synchronized Handler<Void> pingResponseHandler() {
        return this.pingrespHandler;
    }

    @Override
    public synchronized MqttClient exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized MqttClient closeHandler(Handler<Void> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    private synchronized Handler<Void> closeHandler() {
        return this.closeHandler;
    }

    @Override
    public MqttClient ping() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PINGREQ, false, MqttQoS.AT_MOST_ONCE, false, 0);
        io.netty.handler.codec.mqtt.MqttMessage pingreq = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, null, null);
        this.write(pingreq);
        return this;
    }

    @Override
    public synchronized String clientId() {
        return this.options.getClientId();
    }

    @Override
    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    private void publishAcknowledge(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        io.netty.handler.codec.mqtt.MqttMessage puback = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(puback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishReceived(io.vertx.mqtt.messages.MqttPublishMessage publishMessage) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessage.messageId());
        io.netty.handler.codec.mqtt.MqttMessage pubrec = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        MqttClientImpl mqttClientImpl = this;
        synchronized (mqttClientImpl) {
            this.qos2inbound.put(publishMessage.messageId(), publishMessage);
        }
        this.write(pubrec);
    }

    private void publishComplete(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        io.netty.handler.codec.mqtt.MqttMessage pubcomp = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(pubcomp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishRelease(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        io.netty.handler.codec.mqtt.MqttMessage pubrel = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        MqttClientImpl mqttClientImpl = this;
        synchronized (mqttClientImpl) {
            this.qos2outbound.put(publishMessageId, pubrel);
        }
        this.write(pubrel);
    }

    private void initChannel(ChannelPipeline pipeline) {
        pipeline.addBefore("handler", "mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
        if (this.options.getMaxMessageSize() > 0) {
            pipeline.addBefore("handler", "mqttDecoder", (ChannelHandler)new MqttDecoder(this.options.getMaxMessageSize()));
        } else {
            pipeline.addBefore("handler", "mqttDecoder", (ChannelHandler)new MqttDecoder());
        }
        if (this.options.isAutoKeepAlive() && this.options.getKeepAliveTimeSeconds() != 0) {
            pipeline.addBefore("handler", "idle", (ChannelHandler)new IdleStateHandler(0, this.options.getKeepAliveTimeSeconds(), 0));
            pipeline.addBefore("handler", "keepAliveHandler", (ChannelHandler)new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    IdleStateEvent e;
                    if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
                        MqttClientImpl.this.ping();
                    }
                }
            });
        }
    }

    private synchronized int nextMessageId() {
        this.messageIdCounter = this.messageIdCounter % 65535 != 0 ? this.messageIdCounter + 1 : 1;
        return this.messageIdCounter;
    }

    private synchronized NetSocketInternal connection() {
        return this.connection;
    }

    void write(io.netty.handler.codec.mqtt.MqttMessage mqttMessage) {
        log.debug((Object)String.format("Sending packet %s", mqttMessage));
        this.connection().writeMessage((Object)mqttMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClosed() {
        MqttClientImpl mqttClientImpl = this;
        synchronized (mqttClientImpl) {
            boolean isConnected = this.isConnected;
            this.isConnected = false;
            if (!isConnected) {
                return;
            }
        }
        Handler<Void> handler = this.closeHandler();
        if (handler != null) {
            handler.handle(null);
        }
    }

    private void handleMessage(ChannelHandlerContext chctx, Object msg) {
        if (msg instanceof io.netty.handler.codec.mqtt.MqttMessage) {
            io.netty.handler.codec.mqtt.MqttMessage mqttMessage = (io.netty.handler.codec.mqtt.MqttMessage)msg;
            DecoderResult result = mqttMessage.decoderResult();
            if (result.isFailure()) {
                chctx.pipeline().fireExceptionCaught(result.cause());
                return;
            }
            if (!result.isFinished()) {
                chctx.pipeline().fireExceptionCaught((Throwable)new Exception("Unfinished message"));
                return;
            }
            log.debug((Object)String.format("Incoming packet %s", msg));
            switch (mqttMessage.fixedHeader().messageType()) {
                case CONNACK: {
                    io.netty.handler.codec.mqtt.MqttConnAckMessage connack = (io.netty.handler.codec.mqtt.MqttConnAckMessage)mqttMessage;
                    MqttConnAckMessage mqttConnAckMessage = MqttConnAckMessage.create(connack.variableHeader().connectReturnCode(), connack.variableHeader().isSessionPresent());
                    this.handleConnack(mqttConnAckMessage);
                    break;
                }
                case PUBLISH: {
                    MqttPublishMessage publish = (MqttPublishMessage)mqttMessage;
                    ByteBuf newBuf = VertxHandler.safeBuffer((ByteBuf)publish.payload(), (ByteBufAllocator)chctx.alloc());
                    io.vertx.mqtt.messages.MqttPublishMessage mqttPublishMessage = io.vertx.mqtt.messages.MqttPublishMessage.create(publish.variableHeader().packetId(), publish.fixedHeader().qosLevel(), publish.fixedHeader().isDup(), publish.fixedHeader().isRetain(), publish.variableHeader().topicName(), newBuf);
                    this.handlePublish(mqttPublishMessage);
                    break;
                }
                case PUBACK: {
                    this.handlePuback(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case PUBREC: {
                    this.handlePubrec(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case PUBREL: {
                    this.handlePubrel(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case PUBCOMP: {
                    this.handlePubcomp(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case SUBACK: {
                    MqttSubAckMessage unsuback = (MqttSubAckMessage)mqttMessage;
                    io.vertx.mqtt.messages.MqttSubAckMessage mqttSubAckMessage = io.vertx.mqtt.messages.MqttSubAckMessage.create(unsuback.variableHeader().messageId(), unsuback.payload().grantedQoSLevels());
                    this.handleSuback(mqttSubAckMessage);
                    break;
                }
                case UNSUBACK: {
                    this.handleUnsuback(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case PINGRESP: {
                    this.handlePingresp();
                    break;
                }
                default: {
                    chctx.pipeline().fireExceptionCaught((Throwable)new Exception("Wrong message type " + msg.getClass().getName()));
                    break;
                }
            }
        } else {
            chctx.pipeline().fireExceptionCaught((Throwable)new Exception("Wrong message type"));
        }
    }

    private void handlePingresp() {
        Handler<Void> handler = this.pingResponseHandler();
        if (handler != null) {
            handler.handle(null);
        }
    }

    private void handleUnsuback(int unsubackMessageId) {
        Handler<Integer> handler = this.unsubscribeCompletionHandler();
        if (handler != null) {
            handler.handle((Object)unsubackMessageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePuback(int pubackMessageId) {
        MqttClientImpl mqttClientImpl = this;
        synchronized (mqttClientImpl) {
            io.netty.handler.codec.mqtt.MqttMessage removedPacket = this.qos1outbound.remove(pubackMessageId);
            if (removedPacket == null) {
                log.warn((Object)"Received PUBACK packet without having related PUBLISH packet in storage");
                return;
            }
            --this.countInflightQueue;
        }
        Handler<Integer> handler = this.publishCompletionHandler();
        if (handler != null) {
            handler.handle((Object)pubackMessageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePubcomp(int pubcompMessageId) {
        MqttClientImpl mqttClientImpl = this;
        synchronized (mqttClientImpl) {
            io.netty.handler.codec.mqtt.MqttMessage removedPacket = this.qos2outbound.remove(pubcompMessageId);
            if (removedPacket == null) {
                log.warn((Object)"Received PUBCOMP packet without having related PUBREL packet in storage");
                return;
            }
            --this.countInflightQueue;
        }
        Handler<Integer> handler = this.publishCompletionHandler();
        if (handler != null) {
            handler.handle((Object)pubcompMessageId);
        }
    }

    private void handlePubrec(int pubrecMessageId) {
        this.publishRelease(pubrecMessageId);
    }

    private void handleSuback(io.vertx.mqtt.messages.MqttSubAckMessage msg) {
        Handler<io.vertx.mqtt.messages.MqttSubAckMessage> handler = this.subscribeCompletionHandler();
        if (handler != null) {
            handler.handle((Object)msg);
        }
    }

    private void handlePublish(io.vertx.mqtt.messages.MqttPublishMessage msg) {
        switch (msg.qosLevel()) {
            case AT_MOST_ONCE: {
                Handler<io.vertx.mqtt.messages.MqttPublishMessage> handler = this.publishHandler();
                if (handler == null) break;
                handler.handle((Object)msg);
                break;
            }
            case AT_LEAST_ONCE: {
                this.publishAcknowledge(msg.messageId());
                Handler<io.vertx.mqtt.messages.MqttPublishMessage> handler = this.publishHandler();
                if (handler == null) break;
                handler.handle((Object)msg);
                break;
            }
            case EXACTLY_ONCE: {
                this.publishReceived(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePubrel(int pubrelMessageId) {
        MqttMessage message;
        MqttClientImpl mqttClientImpl = this;
        synchronized (mqttClientImpl) {
            message = this.qos2inbound.remove(pubrelMessageId);
            if (message == null) {
                log.warn((Object)"Received PUBREL packet without having related PUBREC packet in storage");
                return;
            }
            this.publishComplete(pubrelMessageId);
        }
        Handler<io.vertx.mqtt.messages.MqttPublishMessage> handler = this.publishHandler();
        if (handler != null) {
            handler.handle((Object)((io.vertx.mqtt.messages.MqttPublishMessage)message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnack(MqttConnAckMessage msg) {
        MqttClientImpl mqttClientImpl = this;
        synchronized (mqttClientImpl) {
            this.isConnected = msg.code() == MqttConnectReturnCode.CONNECTION_ACCEPTED;
        }
        Handler<AsyncResult<MqttConnAckMessage>> handler = this.connectHandler();
        if (handler != null) {
            if (msg.code() == MqttConnectReturnCode.CONNECTION_ACCEPTED) {
                handler.handle((Object)Future.succeededFuture((Object)msg));
            } else {
                MqttConnectionException exception = new MqttConnectionException(msg.code());
                log.error((Object)String.format("Connection refused by the server - code: %s", msg.code()));
                handler.handle((Object)Future.failedFuture((Throwable)exception));
            }
        }
    }

    private void handleException(Throwable t) {
        Handler<Throwable> handler = this.exceptionHandler();
        if (handler != null) {
            handler.handle((Object)t);
        }
    }

    private String generateRandomClientId() {
        return UUID.randomUUID().toString();
    }

    private boolean isValidTopicName(String topicName) {
        if (!this.isValidStringSizeInUTF8(topicName)) {
            return false;
        }
        Matcher matcher = validTopicNamePattern.matcher(topicName);
        return matcher.find();
    }

    private boolean isValidTopicFilter(String topicFilter) {
        if (!this.isValidStringSizeInUTF8(topicFilter)) {
            return false;
        }
        Matcher matcher = validTopicFilterPattern.matcher(topicFilter);
        return matcher.find();
    }

    private boolean isValidStringSizeInUTF8(String string) {
        try {
            int length = string.getBytes("UTF-8").length;
            return length >= 1 && length <= 65535;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"UTF-8 charset is not supported", (Throwable)e);
            return false;
        }
    }
}

