/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.sqlclient.DatabaseException;
import java.util.ArrayList;
import java.util.List;

public class MSSQLException
extends DatabaseException {
    private final byte state;
    private final byte severity;
    private final String errorMessage;
    private final String serverName;
    private final String procedureName;
    private final int lineNumber;
    private List<MSSQLException> additional;

    public MSSQLException(int number, byte state, byte severity, String errorMessage, String serverName, String procedureName, int lineNumber) {
        super(MSSQLException.formatMessage(number, state, severity, errorMessage, serverName, procedureName, lineNumber), number, MSSQLException.generateStateCode(number, state));
        this.state = state;
        this.severity = severity;
        this.errorMessage = errorMessage;
        this.serverName = serverName;
        this.procedureName = procedureName;
        this.lineNumber = lineNumber;
    }

    static String generateStateCode(int errNum, int databaseState) {
        switch (errNum) {
            case 8152: {
                return "22001";
            }
            case 515: 
            case 547: 
            case 2601: 
            case 2627: {
                return "23000";
            }
            case 2714: {
                return "S0001";
            }
            case 208: {
                return "S0002";
            }
            case 1205: {
                return "40001";
            }
        }
        return "S" + String.format("%4s", databaseState).replaceAll(" ", "0");
    }

    public void add(MSSQLException e) {
        if (this.additional == null) {
            this.additional = new ArrayList<MSSQLException>(3);
        }
        this.additional.add(e);
    }

    public byte state() {
        return this.state;
    }

    public byte severity() {
        return this.severity;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String serverName() {
        return this.serverName;
    }

    public String procedureName() {
        return this.procedureName;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public List<MSSQLException> additional() {
        return this.additional;
    }

    private static String formatMessage(int number, byte state, byte severity, String errorMessage, String serverName, String procedureName, int lineNumber) {
        StringBuilder sb = new StringBuilder("{").append("number=").append(number).append(", state=").append(state).append(", severity=").append(severity);
        if (errorMessage != null && !errorMessage.isEmpty()) {
            sb.append(", message='").append(errorMessage).append('\'');
        }
        if (serverName != null && !serverName.isEmpty()) {
            sb.append(", serverName='").append(serverName).append('\'');
        }
        if (procedureName != null && !procedureName.isEmpty()) {
            sb.append(", procedureName='").append(procedureName).append('\'');
        }
        sb.append(", lineNumber=").append(lineNumber);
        return sb.append('}').toString();
    }
}

