/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.net.HostAndPort;
import io.vertx.mssqlclient.impl.MSSQLSocketConnection;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.mssqlclient.impl.utils.ByteBufUtils;
import io.vertx.mssqlclient.impl.utils.Utils;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.command.InitCommand;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;

class InitCommandCodec
extends MSSQLCommandCodec<Connection, InitCommand> {
    static final Object LOGIN_SENT = new Object();

    InitCommandCodec(TdsMessageCodec tdsMessageCodec, InitCommand cmd) {
        super(tdsMessageCodec, cmd);
    }

    @Override
    void encode() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        int startIdx = content.writerIndex();
        content.writeZero(4);
        content.writeInt(0x4000074);
        content.writeIntLE(this.tdsMessageCodec.encoder().packetSize());
        content.writeZero(12);
        content.writeByte(-64);
        content.writeByte(2);
        content.writeByte(0);
        content.writeByte(0);
        content.writeZero(8);
        Map properties = ((InitCommand)this.cmd).properties();
        String hostName = Utils.getHostName();
        int hostNameOffsetLengthIdx = content.writerIndex();
        content.writeZero(2);
        content.writeShortLE(hostName.length());
        String userName = ((InitCommand)this.cmd).username();
        int userNameOffsetLengthIdx = content.writerIndex();
        content.writeZero(2);
        content.writeShortLE(userName.length());
        String password = ((InitCommand)this.cmd).password();
        int passwordOffsetLengthIdx = content.writerIndex();
        content.writeZero(2);
        content.writeShortLE(password.length());
        CharSequence appName = (CharSequence)properties.get("appName");
        if (appName == null || appName.length() == 0) {
            appName = "vertx-mssql-client";
        }
        int appNameOffsetLengthIdx = content.writerIndex();
        content.writeZero(2);
        content.writeShortLE(appName.length());
        String serverName = ((MSSQLSocketConnection)((InitCommand)this.cmd).connection()).socket().remoteAddress().host();
        int serverNameOffsetLengthIdx = content.writerIndex();
        content.writeZero(2);
        content.writeShortLE(serverName.length());
        int unusedOffsetLengthIdx = content.writerIndex();
        content.writeZero(4);
        CharSequence interfaceLibraryName = (CharSequence)properties.get("clientInterfaceName");
        if (interfaceLibraryName == null || interfaceLibraryName.length() == 0) {
            interfaceLibraryName = "Vert.x";
        }
        int cltIntNameOffsetLengthIdx = content.writerIndex();
        content.writeZero(2);
        content.writeShortLE(interfaceLibraryName.length());
        int languageOffsetLengthIdx = content.writerIndex();
        content.writeZero(4);
        String database = ((InitCommand)this.cmd).database();
        int databaseOffsetLengthIdx = content.writerIndex();
        content.writeZero(2);
        content.writeShortLE(database.length());
        content.writeZero(6);
        int sspiOffsetLengthIdx = content.writerIndex();
        content.writeZero(4);
        int atchDbFileOffsetLengthIdx = content.writerIndex();
        content.writeZero(4);
        int changePasswordOffsetLengthIdx = content.writerIndex();
        content.writeZero(4);
        content.writeZero(4);
        content.setShortLE(hostNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence((CharSequence)hostName, StandardCharsets.UTF_16LE);
        content.setShortLE(userNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence((CharSequence)userName, StandardCharsets.UTF_16LE);
        content.setShortLE(passwordOffsetLengthIdx, content.writerIndex() - startIdx);
        this.writePassword(content, password);
        content.setShortLE(appNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence(appName, StandardCharsets.UTF_16LE);
        content.setShortLE(serverNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence((CharSequence)serverName, StandardCharsets.UTF_16LE);
        content.setShortLE(unusedOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setShortLE(cltIntNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence(interfaceLibraryName, StandardCharsets.UTF_16LE);
        content.setShortLE(languageOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setShortLE(databaseOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence((CharSequence)database, StandardCharsets.UTF_16LE);
        content.setShortLE(sspiOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setShortLE(atchDbFileOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setShortLE(changePasswordOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setIntLE(startIdx, content.writerIndex() - startIdx);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)16, content);
        this.tdsMessageCodec.chctx().pipeline().fireUserEventTriggered(LOGIN_SENT);
    }

    private void writePassword(ByteBuf payload, String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_16LE);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            bytes[i] = (byte)((b >> 4 | (b & 0xF) << 4) ^ 0xA5);
        }
        payload.writeBytes(bytes);
    }

    @Override
    protected void handleLoginAck() {
        this.result = ((InitCommand)this.cmd).connection();
    }

    @Override
    protected void handleRouting(ByteBuf payload) {
        MSSQLSocketConnection conn = (MSSQLSocketConnection)((Object)this.result);
        if (conn == null) {
            throw new IllegalStateException("Routing ENVCHANGE token MUST be sent after the LOGINACK token in the login response");
        }
        if (payload.readUnsignedShortLE() <= 5) {
            throw new IllegalStateException("RoutingDataValueLength too short");
        }
        if (payload.readUnsignedByte() != 0) {
            throw new IllegalStateException("Protocol MUST be 0, specifying TCP-IP protocol");
        }
        int port = payload.readUnsignedShortLE();
        if (port == 0) {
            throw new IllegalStateException("ProtocolProperty value of zero is not allowed when Protocol is TCP-IP");
        }
        String host = ByteBufUtils.readUnsignedShortLengthString(payload);
        conn.setAlternateServer(HostAndPort.create((String)host.toLowerCase(Locale.ENGLISH), (int)port));
    }
}

