/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.MSSQLDatabaseMetadata;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.mssqlclient.impl.command.PreLoginCommand;
import io.vertx.mssqlclient.impl.command.PreLoginResponse;
import io.vertx.sqlclient.internal.command.CommandResponse;

class PreLoginCommandCodec
extends MSSQLCommandCodec<PreLoginResponse, PreLoginCommand> {
    private static final int VERSION = 0;
    private static final int ENCRYPTION = 1;
    private static final int TERMINATOR = 255;

    PreLoginCommandCodec(TdsMessageCodec tdsMessageCodec, PreLoginCommand cmd) {
        super(tdsMessageCodec, cmd);
    }

    @Override
    void encode() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        int versionOptionIndex = this.encodeOption(content, 0);
        int encryptionOptionIndex = this.encodeOption(content, 1);
        content.writeByte(255);
        this.encodeOptionOffset(content, versionOptionIndex, content.writerIndex());
        this.encodeOptionLength(content, versionOptionIndex, 6);
        content.writeZero(6);
        this.encodeOptionOffset(content, encryptionOptionIndex, content.writerIndex());
        this.encodeOptionLength(content, encryptionOptionIndex, 1);
        content.writeByte(((PreLoginCommand)this.cmd).sslRequired() ? 1 : 0);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)18, content);
    }

    private int encodeOption(ByteBuf content, int token) {
        int start = content.writerIndex();
        content.writeByte(token);
        content.writeZero(4);
        return start;
    }

    private void encodeOptionOffset(ByteBuf content, int optionIndex, int offset) {
        content.setShort(optionIndex + 1, offset);
    }

    private void encodeOptionLength(ByteBuf content, int optionIndex, int length) {
        content.setShort(optionIndex + 3, length);
    }

    @Override
    void decode(ByteBuf payload) {
        short optionType;
        int startOfMessage = payload.readerIndex();
        MSSQLDatabaseMetadata metadata = null;
        Byte encryptionLevel = null;
        while ((optionType = payload.readUnsignedByte()) != 255) {
            int offset = payload.readUnsignedShort();
            payload.skipBytes(2);
            payload.markReaderIndex();
            payload.readerIndex(startOfMessage + offset);
            if (optionType == 0) {
                short major = payload.readUnsignedByte();
                short minor = payload.readUnsignedByte();
                int build = payload.readUnsignedShort();
                metadata = new MSSQLDatabaseMetadata(String.format("%d.%d.%d", major, (int)minor, build), major, minor);
            } else if (optionType == 1) {
                encryptionLevel = payload.readByte();
            }
            payload.resetReaderIndex();
        }
        this.tdsMessageCodec.decoder().fireCommandResponse(CommandResponse.success((Object)new PreLoginResponse(metadata, encryptionLevel)));
    }
}

