/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLDatabaseMetadata;
import io.vertx.mysqlclient.impl.codec.AuthenticationCommandBaseCodec;
import io.vertx.mysqlclient.impl.command.InitialHandshakeCommand;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.mysqlclient.impl.util.CachingSha2Authenticator;
import io.vertx.mysqlclient.impl.util.Native41Authenticator;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class InitialHandshakeCommandCodec
extends AuthenticationCommandBaseCodec<Connection, InitialHandshakeCommand> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialHandshakeCommandCodec.class);
    private static final int AUTH_PLUGIN_DATA_PART1_LENGTH = 8;
    private static final int ST_CONNECTING = 0;
    private static final int ST_AUTHENTICATING = 1;
    private static final int ST_CONNECTED = 2;
    private int status = 0;

    InitialHandshakeCommandCodec(InitialHandshakeCommand cmd) {
        super(cmd);
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        switch (this.status) {
            case 0: {
                this.handleInitialHandshake(payload);
                this.status = 1;
                break;
            }
            case 1: {
                this.handleAuthentication(payload);
            }
        }
    }

    private void handleInitialHandshake(ByteBuf payload) {
        boolean upgradeToSsl;
        short lenOfAuthPluginData;
        boolean isClientPluginAuthSupported;
        MySQLDatabaseMetadata md;
        this.encoder.clientCapabilitiesFlag = ((InitialHandshakeCommand)this.cmd).initialCapabilitiesFlags();
        this.encoder.encodingCharset = ((InitialHandshakeCommand)this.cmd).charsetEncoding();
        short protocolVersion = payload.readUnsignedByte();
        String serverVersion = BufferUtils.readNullTerminatedString(payload, StandardCharsets.US_ASCII);
        this.encoder.socketConnection.metaData = md = MySQLDatabaseMetadata.parse(serverVersion);
        if (md.majorVersion() != 5 || md.minorVersion() >= 7 && (md.minorVersion() != 7 || md.microVersion() >= 5)) {
            this.encoder.clientCapabilitiesFlag |= 0x1000000;
        }
        long connectionId = payload.readUnsignedIntLE();
        this.authPluginData = new byte[20];
        payload.readBytes(this.authPluginData, 0, 8);
        payload.readByte();
        int lowerServerCapabilitiesFlags = payload.readUnsignedShortLE();
        short characterSet = payload.readUnsignedByte();
        int statusFlags = payload.readUnsignedShortLE();
        int capabilityFlagsUpper = payload.readUnsignedShortLE();
        int serverCapabilitiesFlags = lowerServerCapabilitiesFlags | capabilityFlagsUpper << 16;
        boolean bl = isClientPluginAuthSupported = (serverCapabilitiesFlags & 0x80000) != 0;
        if (isClientPluginAuthSupported) {
            lenOfAuthPluginData = payload.readUnsignedByte();
        } else {
            payload.readerIndex(payload.readerIndex() + 1);
            lenOfAuthPluginData = 0;
        }
        payload.readerIndex(payload.readerIndex() + 10);
        payload.readBytes(this.authPluginData, 8, Math.max(12, lenOfAuthPluginData - 9));
        payload.readByte();
        String serverAuthPluginName = BufferUtils.readNullTerminatedString(payload, StandardCharsets.UTF_8);
        SslMode sslMode = ((InitialHandshakeCommand)this.cmd).sslMode();
        switch (sslMode) {
            case DISABLED: {
                upgradeToSsl = false;
                break;
            }
            case PREFERRED: {
                upgradeToSsl = this.isTlsSupportedByServer(serverCapabilitiesFlags);
                break;
            }
            case REQUIRED: 
            case VERIFY_CA: 
            case VERIFY_IDENTITY: {
                upgradeToSsl = true;
                break;
            }
            default: {
                this.encoder.handleCommandResponse(CommandResponse.failure((Throwable)new IllegalStateException("Unknown SSL mode to handle: " + (Object)((Object)sslMode))));
                return;
            }
        }
        if (upgradeToSsl) {
            this.encoder.clientCapabilitiesFlag |= 0x800;
            this.sendSslRequest();
            this.encoder.socketConnection.upgradeToSsl((Handler<AsyncResult<Void>>)((Handler)upgrade -> {
                if (upgrade.succeeded()) {
                    this.doSendHandshakeResponseMessage(serverAuthPluginName, ((InitialHandshakeCommand)this.cmd).authenticationPlugin(), this.authPluginData, serverCapabilitiesFlags);
                } else {
                    this.encoder.handleCommandResponse(CommandResponse.failure((Throwable)upgrade.cause()));
                }
            }));
        } else {
            this.doSendHandshakeResponseMessage(serverAuthPluginName, ((InitialHandshakeCommand)this.cmd).authenticationPlugin(), this.authPluginData, serverCapabilitiesFlags);
        }
    }

    private void doSendHandshakeResponseMessage(String serverAuthPluginName, MySQLAuthenticationPlugin authPlugin, byte[] nonce, int serverCapabilitiesFlags) {
        Map<String, String> clientConnectionAttributes = ((InitialHandshakeCommand)this.cmd).connectionAttributes();
        this.encoder.clientCapabilitiesFlag &= serverCapabilitiesFlags;
        String clientPluginName = authPlugin == MySQLAuthenticationPlugin.DEFAULT ? serverAuthPluginName : authPlugin.value;
        this.sendHandshakeResponseMessage(((InitialHandshakeCommand)this.cmd).username(), ((InitialHandshakeCommand)this.cmd).password(), ((InitialHandshakeCommand)this.cmd).database(), nonce, clientPluginName, clientConnectionAttributes);
    }

    private void handleAuthentication(ByteBuf payload) {
        short header = payload.getUnsignedByte(payload.readerIndex());
        switch (header) {
            case 0: {
                this.status = 2;
                this.encoder.handleCommandResponse(CommandResponse.success((Object)((InitialHandshakeCommand)this.cmd).connection()));
                break;
            }
            case 255: {
                this.handleErrorPacketPayload(payload);
                break;
            }
            case 254: {
                this.handleAuthSwitchRequest(((InitialHandshakeCommand)this.cmd).password(), payload);
                break;
            }
            case 1: {
                this.handleAuthMoreData(((InitialHandshakeCommand)this.cmd).password().getBytes(StandardCharsets.UTF_8), payload);
                break;
            }
            default: {
                this.encoder.handleCommandResponse(CommandResponse.failure((Throwable)new IllegalStateException("Unhandled state with header: " + header)));
            }
        }
    }

    private void handleAuthSwitchRequest(String password, ByteBuf payload) {
        payload.skipBytes(1);
        String pluginName = BufferUtils.readNullTerminatedString(payload, StandardCharsets.UTF_8);
        byte[] nonce = new byte[20];
        payload.readBytes(nonce);
        switch (pluginName) {
            case "mysql_native_password": {
                this.sendBytesAsPacket(Native41Authenticator.encode(password.getBytes(StandardCharsets.UTF_8), nonce));
                break;
            }
            case "caching_sha2_password": {
                this.sendBytesAsPacket(CachingSha2Authenticator.encode(password.getBytes(StandardCharsets.UTF_8), nonce));
                break;
            }
            case "mysql_clear_password": {
                ByteBuf buffer = this.encoder.chctx.alloc().buffer();
                BufferUtils.writeNullTerminatedString(buffer, password, StandardCharsets.UTF_8);
                this.sendNonSplitPacket(buffer);
                break;
            }
            default: {
                this.encoder.handleCommandResponse(CommandResponse.failure((Throwable)new UnsupportedOperationException("Unsupported authentication method: " + pluginName)));
                return;
            }
        }
    }

    private void sendSslRequest() {
        ByteBuf packet = this.allocateBuffer(36);
        packet.writeMediumLE(32);
        packet.writeByte(this.sequenceId);
        packet.writeIntLE(this.encoder.clientCapabilitiesFlag);
        packet.writeIntLE(0xFFFFFF);
        packet.writeByte(((InitialHandshakeCommand)this.cmd).collation().collationId());
        packet.writeZero(23);
        this.sendNonSplitPacket(packet);
    }

    private void sendHandshakeResponseMessage(String username, String password, String database, byte[] nonce, String clientPluginName, Map<String, String> clientConnectionAttributes) {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        int clientCapabilitiesFlags = this.encoder.clientCapabilitiesFlag;
        packet.writeIntLE(clientCapabilitiesFlags);
        packet.writeIntLE(0xFFFFFF);
        packet.writeByte(((InitialHandshakeCommand)this.cmd).collation().collationId());
        packet.writeZero(23);
        BufferUtils.writeNullTerminatedString(packet, username, StandardCharsets.UTF_8);
        String authMethod = clientPluginName;
        if (password.isEmpty()) {
            packet.writeByte(0);
        } else {
            byte[] authResponse;
            switch (authMethod) {
                case "mysql_native_password": {
                    authResponse = Native41Authenticator.encode(password.getBytes(StandardCharsets.UTF_8), nonce);
                    break;
                }
                case "caching_sha2_password": {
                    authResponse = CachingSha2Authenticator.encode(password.getBytes(StandardCharsets.UTF_8), nonce);
                    break;
                }
                case "mysql_clear_password": {
                    ByteBuf buffer = this.encoder.chctx.alloc().heapBuffer();
                    BufferUtils.writeNullTerminatedString(buffer, password, StandardCharsets.UTF_8);
                    authResponse = new byte[buffer.readableBytes()];
                    buffer.readBytes(authResponse);
                    break;
                }
                default: {
                    LOGGER.warn((Object)("Unknown authentication method: " + authMethod + ", the client will try to use mysql_native_password instead."));
                    authMethod = "mysql_native_password";
                    authResponse = Native41Authenticator.encode(password.getBytes(StandardCharsets.UTF_8), nonce);
                }
            }
            if ((clientCapabilitiesFlags & 0x200000) != 0) {
                BufferUtils.writeLengthEncodedInteger(packet, authResponse.length);
                packet.writeBytes(authResponse);
            } else if ((clientCapabilitiesFlags & 0x8000) != 0) {
                packet.writeByte(authResponse.length);
                packet.writeBytes(authResponse);
            } else {
                packet.writeByte(0);
            }
        }
        if ((clientCapabilitiesFlags & 8) != 0) {
            BufferUtils.writeNullTerminatedString(packet, database, StandardCharsets.UTF_8);
        }
        if ((clientCapabilitiesFlags & 0x80000) != 0) {
            BufferUtils.writeNullTerminatedString(packet, authMethod, StandardCharsets.UTF_8);
        }
        if ((clientCapabilitiesFlags & 0x100000) != 0) {
            this.encodeConnectionAttributes(clientConnectionAttributes, packet);
        }
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }

    private boolean isTlsSupportedByServer(int serverCapabilitiesFlags) {
        return (serverCapabilitiesFlags & 0x800) != 0;
    }
}

