/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.oracleclient.OracleConnectOptionsConverter;
import io.vertx.oracleclient.ServerMode;
import io.vertx.oracleclient.impl.OracleConnectionUriParser;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.Map;
import java.util.function.Predicate;

@DataObject(generateConverter=true)
public class OracleConnectOptions
extends SqlConnectOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 1521;
    public static final String DEFAULT_USER = "";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_DATABASE = "";
    private String serviceId;
    private String serviceName;
    private ServerMode serverMode;
    private String instanceName;
    private String tnsAlias;
    private String tnsAdmin;

    public static OracleConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof OracleConnectOptions) {
            return (OracleConnectOptions)options;
        }
        return new OracleConnectOptions(options);
    }

    public OracleConnectOptions() {
    }

    public OracleConnectOptions(OracleConnectOptions other) {
        super((SqlConnectOptions)other);
        this.copyFields(other);
    }

    private void copyFields(OracleConnectOptions other) {
        this.serviceId = other.serviceId;
        this.serviceName = other.serviceName;
        this.serverMode = other.serverMode;
        this.instanceName = other.instanceName;
        this.tnsAlias = other.tnsAlias;
        this.tnsAdmin = other.tnsAdmin;
    }

    public OracleConnectOptions(SqlConnectOptions options) {
        super(options);
        if (options instanceof OracleConnectOptions) {
            OracleConnectOptions opts = (OracleConnectOptions)options;
            this.copyFields(opts);
        }
    }

    public OracleConnectOptions(JsonObject json) {
        super(json);
        OracleConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public static OracleConnectOptions fromUri(String connectionUri) throws IllegalArgumentException {
        JsonObject parsedConfiguration = OracleConnectionUriParser.parse(connectionUri);
        return new OracleConnectOptions(parsedConfiguration);
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public OracleConnectOptions setServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public OracleConnectOptions setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public ServerMode getServerMode() {
        return this.serverMode;
    }

    public OracleConnectOptions setServerMode(ServerMode serverMode) {
        this.serverMode = serverMode;
        return this;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public OracleConnectOptions setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public String getTnsAlias() {
        return this.tnsAlias;
    }

    public OracleConnectOptions setTnsAlias(String tnsAlias) {
        this.tnsAlias = tnsAlias;
        return this;
    }

    public String getTnsAdmin() {
        return this.tnsAdmin;
    }

    public OracleConnectOptions setTnsAdmin(String tnsAdmin) {
        this.tnsAdmin = tnsAdmin;
        return this;
    }

    public String getHost() {
        return super.getHost();
    }

    public OracleConnectOptions setHost(String host) {
        return (OracleConnectOptions)super.setHost(host);
    }

    public int getPort() {
        return super.getPort();
    }

    public OracleConnectOptions setPort(int port) {
        return (OracleConnectOptions)super.setPort(port);
    }

    public String getUser() {
        return super.getUser();
    }

    public OracleConnectOptions setUser(String user) {
        return (OracleConnectOptions)super.setUser(user);
    }

    public String getPassword() {
        return super.getPassword();
    }

    public OracleConnectOptions setPassword(String password) {
        return (OracleConnectOptions)super.setPassword(password);
    }

    public String getDatabase() {
        return super.getDatabase();
    }

    public OracleConnectOptions setDatabase(String database) {
        return (OracleConnectOptions)super.setDatabase(database);
    }

    public boolean getCachePreparedStatements() {
        return super.getCachePreparedStatements();
    }

    public OracleConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        return (OracleConnectOptions)super.setCachePreparedStatements(cachePreparedStatements);
    }

    public int getPreparedStatementCacheMaxSize() {
        return super.getPreparedStatementCacheMaxSize();
    }

    public OracleConnectOptions setPreparedStatementCacheMaxSize(int preparedStatementCacheMaxSize) {
        return (OracleConnectOptions)super.setPreparedStatementCacheMaxSize(preparedStatementCacheMaxSize);
    }

    public Predicate<String> getPreparedStatementCacheSqlFilter() {
        return super.getPreparedStatementCacheSqlFilter();
    }

    @GenIgnore
    public OracleConnectOptions setPreparedStatementCacheSqlFilter(Predicate<String> predicate) {
        return (OracleConnectOptions)super.setPreparedStatementCacheSqlFilter(predicate);
    }

    public OracleConnectOptions setPreparedStatementCacheSqlLimit(int preparedStatementCacheSqlLimit) {
        return (OracleConnectOptions)super.setPreparedStatementCacheSqlLimit(preparedStatementCacheSqlLimit);
    }

    public Map<String, String> getProperties() {
        return super.getProperties();
    }

    public OracleConnectOptions setProperties(Map<String, String> properties) {
        return (OracleConnectOptions)super.setProperties(properties);
    }

    @GenIgnore
    public OracleConnectOptions addProperty(String key, String value) {
        return (OracleConnectOptions)super.addProperty(key, value);
    }

    public SocketAddress getSocketAddress() {
        return super.getSocketAddress();
    }

    public TracingPolicy getTracingPolicy() {
        return super.getTracingPolicy();
    }

    public OracleConnectOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        return (OracleConnectOptions)super.setTracingPolicy(tracingPolicy);
    }

    public OracleConnectOptions setSsl(boolean ssl) {
        return (OracleConnectOptions)super.setSsl(ssl);
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        OracleConnectOptionsConverter.toJson(this, json);
        return json;
    }

    protected void init() {
        this.setHost(DEFAULT_HOST);
        this.setPort(1521);
        this.setUser("");
        this.setPassword("");
        this.setDatabase("");
    }

    public OracleConnectOptions merge(JsonObject other) {
        JsonObject json = this.toJson();
        json.mergeIn(other);
        return new OracleConnectOptions(json);
    }
}

