/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleConnectionImpl;
import io.vertx.oracleclient.impl.OracleDatabaseHelper;
import io.vertx.oracleclient.impl.OracleJdbcConnection;
import io.vertx.oracleclient.impl.OracleMetadata;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleConnectionFactory
implements ConnectionFactory {
    private final Supplier<? extends Future<? extends SqlConnectOptions>> options;
    private final Map<JsonObject, OracleDataSource> datasources;

    public OracleConnectionFactory(VertxInternal vertx, Supplier<? extends Future<? extends SqlConnectOptions>> options) {
        this.options = options;
        this.datasources = new HashMap<JsonObject, OracleDataSource>();
    }

    public void close(Promise<Void> promise) {
        promise.complete();
    }

    public Future<SqlConnection> connect(Context context) {
        return this.connect(context, this.options.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleDataSource getDatasource(SqlConnectOptions options) {
        OracleDataSource datasource;
        JsonObject key = options.toJson();
        OracleConnectionFactory oracleConnectionFactory = this;
        synchronized (oracleConnectionFactory) {
            datasource = this.datasources.get(key);
            if (datasource == null) {
                datasource = OracleDatabaseHelper.createDataSource(OracleConnectOptions.wrap(options));
                this.datasources.put(key, datasource);
            }
        }
        return datasource;
    }

    public Future<SqlConnection> connect(Context context, SqlConnectOptions options) {
        OracleDataSource datasource = this.getDatasource(options);
        VertxMetrics vertxMetrics = ((VertxInternal)context.owner()).metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
        ContextInternal ctx = (ContextInternal)context;
        return Helper.executeBlocking(context, () -> {
            OracleConnection orac = datasource.createConnectionBuilder().build();
            OracleMetadata metadata = new OracleMetadata(orac.getMetaData());
            OracleJdbcConnection conn = new OracleJdbcConnection(ctx, metrics, OracleConnectOptions.wrap(options), orac, metadata);
            OracleConnectionImpl msConn = new OracleConnectionImpl(ctx, this, conn);
            conn.init((Connection.Holder)msConn);
            return msConn;
        });
    }
}

