/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.VertxException;
import io.vertx.core.json.JsonObject;
import io.vertx.oracleclient.ServerMode;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class OracleConnectionUriParser {
    private static final String SCHEME = "oracle:thin:";

    public static JsonObject parse(String connectionUri) {
        return OracleConnectionUriParser.parse(connectionUri, true);
    }

    public static JsonObject parse(String connectionUri, boolean exact) {
        if (connectionUri == null) {
            if (exact) {
                throw new NullPointerException("connectionUri is null");
            }
            return null;
        }
        if (!connectionUri.startsWith(SCHEME)) {
            if (exact) {
                throw new IllegalArgumentException("Invalid scheme: " + connectionUri);
            }
            return null;
        }
        JsonObject configuration = new JsonObject();
        try {
            ParsingStage stage = ParsingStage.initial(connectionUri, configuration);
            while ((stage = stage.doParse()) != null) {
            }
            return configuration;
        }
        catch (RuntimeException e) {
            RuntimeException caught = e;
            IllegalArgumentException exception = new IllegalArgumentException("Cannot parse invalid connection URI: " + connectionUri);
            if (caught != null) {
                exception.initCause(caught);
            }
            throw exception;
        }
    }

    private static String decodeUrl(String url) {
        return URLDecoder.decode(url, StandardCharsets.UTF_8);
    }

    private static abstract class ParsingStage {
        final String connectionUri;
        final int beginIdx;
        final JsonObject configuration;

        ParsingStage(String connectionUri, int beginIdx, JsonObject configuration) {
            this.connectionUri = connectionUri;
            this.beginIdx = beginIdx;
            this.configuration = configuration;
        }

        static ParsingStage initial(String connectionUri, JsonObject configuration) {
            return new UserAndPassword(connectionUri, OracleConnectionUriParser.SCHEME.length(), configuration);
        }

        abstract ParsingStage doParse();

        ParsingStage afterAtSign(int i) {
            if (i == this.connectionUri.length()) {
                throw new VertxException("Empty net location", true);
            }
            int j = this.connectionUri.indexOf("://", i);
            if (j >= i) {
                return new Protocol(this.connectionUri, i, j, this.configuration);
            }
            if (this.connectionUri.charAt(i) == '(') {
                throw new VertxException("TNS URL Format is not supported", true);
            }
            if (this.configuration.containsKey("user")) {
                return this.hostOrIpV6(i);
            }
            j = this.connectionUri.lastIndexOf(63);
            if (j < i) {
                j = this.connectionUri.length();
            }
            boolean invalidChar = false;
            for (int k = i; k < j; ++k) {
                char c = this.connectionUri.charAt(k);
                if (c != ',' && c != '/' && c != ':') continue;
                invalidChar = true;
                break;
            }
            if (!invalidChar) {
                return new TnsAlias(this.connectionUri, i, j, this.configuration);
            }
            return this.hostOrIpV6(i);
        }

        ParsingStage hostOrIpV6(int i) {
            return this.connectionUri.charAt(i) == '[' ? new Ipv6(this.connectionUri, i + 1, this.configuration) : new Host(this.connectionUri, i, this.configuration);
        }

        ParsingStage afterHost(int i) {
            if (i == this.connectionUri.length()) {
                throw new VertxException("Missing service name or service id", true);
            }
            char c = this.connectionUri.charAt(i);
            if (c == ',') {
                throw new VertxException("URLs with multiple hosts are not supported yet", true);
            }
            if (c == '/') {
                return new ServiceName(this.connectionUri, i + 1, this.configuration);
            }
            if (c == ':') {
                return this.portOrServiceId(i + 1);
            }
            throw new VertxException("Invalid content after host", true);
        }

        ParsingStage portOrServiceId(int i) {
            char c;
            int j;
            for (j = i; j < this.connectionUri.length() && (c = this.connectionUri.charAt(j)) != ',' && c != ':' && c != '/' && c != '?'; ++j) {
                if (Character.getType(c) == 9) continue;
                return new ServiceId(this.connectionUri, i, this.configuration);
            }
            if (i == j) {
                throw new VertxException("Empty port or service id", true);
            }
            return new Port(this.connectionUri, i, j, this.configuration);
        }

        static class ConnectionProps
        extends ParsingStage {
            ConnectionProps(String connectionUri, int beginIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
            }

            @Override
            ParsingStage doParse() {
                if (this.beginIdx == this.connectionUri.length()) {
                    throw new VertxException("Empty connection properties", true);
                }
                JsonObject properties = new JsonObject();
                for (String prop : this.connectionUri.substring(this.beginIdx).split("&")) {
                    if (prop.isEmpty()) {
                        throw new VertxException("Empty connection property", true);
                    }
                    String[] split = prop.split("=");
                    if (split.length != 2) {
                        throw new VertxException("Connection property without value: " + prop, true);
                    }
                    String key = OracleConnectionUriParser.decodeUrl(split[0]);
                    String value = OracleConnectionUriParser.decodeUrl(split[1]);
                    if (key.equalsIgnoreCase("TNS_ADMIN") || key.equalsIgnoreCase("oracle.net.tns_admin")) {
                        this.configuration.put("tnsAdmin", (Object)value);
                        continue;
                    }
                    properties.put(key, (Object)value);
                }
                if (!properties.isEmpty()) {
                    this.configuration.put("properties", (Object)properties);
                }
                return null;
            }
        }

        static class InstanceName
        extends ParsingStage {
            InstanceName(String connectionUri, int beginIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
            }

            @Override
            ParsingStage doParse() {
                if (this.beginIdx == this.connectionUri.length()) {
                    throw new VertxException("Empty instance name", true);
                }
                int i = this.connectionUri.indexOf(63, this.beginIdx);
                if (i > 0) {
                    this.configuration.put("instanceName", (Object)OracleConnectionUriParser.decodeUrl(this.connectionUri.substring(this.beginIdx, i)));
                    return new ConnectionProps(this.connectionUri, i + 1, this.configuration);
                }
                this.configuration.put("instanceName", (Object)OracleConnectionUriParser.decodeUrl(this.connectionUri.substring(this.beginIdx)));
                return null;
            }
        }

        static class ServerMode
        extends ParsingStage {
            ServerMode(String connectionUri, int beginIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
            }

            @Override
            ParsingStage doParse() {
                char c;
                int i;
                for (i = this.beginIdx; i < this.connectionUri.length() && (c = this.connectionUri.charAt(i)) != '/' && c != '?'; ++i) {
                }
                if (this.beginIdx == i) {
                    throw new VertxException("Empty server mode", true);
                }
                io.vertx.oracleclient.ServerMode mode = io.vertx.oracleclient.ServerMode.of(OracleConnectionUriParser.decodeUrl(this.connectionUri.substring(this.beginIdx, i)));
                if (mode == null) {
                    throw new VertxException("Invalid server mode", true);
                }
                this.configuration.put("serverMode", (Object)mode.toString());
                if (i == this.connectionUri.length()) {
                    return null;
                }
                char c2 = this.connectionUri.charAt(i);
                if (c2 == '/') {
                    return new InstanceName(this.connectionUri, i + 1, this.configuration);
                }
                if (c2 == '?') {
                    return new ConnectionProps(this.connectionUri, i + 1, this.configuration);
                }
                throw new IllegalStateException();
            }
        }

        static class ServiceName
        extends ParsingStage {
            ServiceName(String connectionUri, int beginIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
            }

            @Override
            ParsingStage doParse() {
                char c;
                int i;
                for (i = this.beginIdx; i < this.connectionUri.length() && (c = this.connectionUri.charAt(i)) != ':' && c != '/' && c != '?'; ++i) {
                }
                if (this.beginIdx == i) {
                    throw new VertxException("Empty service name", true);
                }
                this.configuration.put("serviceName", (Object)OracleConnectionUriParser.decodeUrl(this.connectionUri.substring(this.beginIdx, i)));
                if (i == this.connectionUri.length()) {
                    return null;
                }
                c = this.connectionUri.charAt(i);
                if (c == ':') {
                    return new ServerMode(this.connectionUri, i + 1, this.configuration);
                }
                if (c == '/') {
                    return new InstanceName(this.connectionUri, i + 1, this.configuration);
                }
                if (c == '?') {
                    return new ConnectionProps(this.connectionUri, i + 1, this.configuration);
                }
                throw new IllegalStateException();
            }
        }

        static class ServiceId
        extends ParsingStage {
            ServiceId(String connectionUri, int beginIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
            }

            @Override
            ParsingStage doParse() {
                int i;
                if (this.beginIdx == this.connectionUri.length() || (i = this.connectionUri.indexOf(63, this.beginIdx)) == this.beginIdx) {
                    throw new VertxException("Empty service id", true);
                }
                if (i >= 0) {
                    this.configuration.put("serviceId", (Object)OracleConnectionUriParser.decodeUrl(this.connectionUri.substring(this.beginIdx, i)));
                    return new ConnectionProps(this.connectionUri, i + 1, this.configuration);
                }
                this.configuration.put("serviceId", (Object)OracleConnectionUriParser.decodeUrl(this.connectionUri.substring(this.beginIdx)));
                return null;
            }
        }

        static class Port
        extends ParsingStage {
            final int endIdx;

            Port(String connectionUri, int beginIdx, int endIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
                this.endIdx = endIdx;
            }

            @Override
            ParsingStage doParse() {
                long port = Long.parseLong(this.connectionUri.substring(this.beginIdx, this.endIdx));
                if (port > 65535L || port <= 0L) {
                    throw new VertxException("The port can only range in 1-65535", true);
                }
                this.configuration.put("port", (Object)port);
                if (this.endIdx == this.connectionUri.length()) {
                    throw new VertxException("Missing service name or service id");
                }
                char c = this.connectionUri.charAt(this.endIdx);
                if (c == ',') {
                    throw new VertxException("URLs with multiple hosts are not supported yet", true);
                }
                if (c == ':') {
                    return new ServiceId(this.connectionUri, this.endIdx + 1, this.configuration);
                }
                if (c == '/') {
                    return new ServiceName(this.connectionUri, this.endIdx + 1, this.configuration);
                }
                throw new IllegalStateException();
            }
        }

        static class Host
        extends ParsingStage {
            Host(String connectionUri, int beginIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
            }

            @Override
            ParsingStage doParse() {
                char c;
                int j;
                for (j = this.beginIdx; j < this.connectionUri.length() && (c = this.connectionUri.charAt(j)) != ',' && c != ':' && c != '/' && c != '?'; ++j) {
                }
                if (this.beginIdx == j) {
                    throw new VertxException("Empty host", true);
                }
                this.configuration.put("host", (Object)OracleConnectionUriParser.decodeUrl(this.connectionUri.substring(this.beginIdx, j)));
                return this.afterHost(j);
            }
        }

        static class Ipv6
        extends ParsingStage {
            Ipv6(String connectionUri, int beginIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
            }

            @Override
            ParsingStage doParse() {
                int i = this.connectionUri.indexOf(93, this.beginIdx);
                if (i < this.beginIdx) {
                    throw new VertxException("Did not find ']' sign", true);
                }
                if (i == this.beginIdx) {
                    throw new VertxException("Empty IPv6 address", true);
                }
                this.configuration.put("host", (Object)this.connectionUri.substring(this.beginIdx, i));
                return this.afterHost(i + 1);
            }
        }

        static class Protocol
        extends ParsingStage {
            final int endIdx;

            Protocol(String connectionUri, int beginIdx, int endIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
                this.endIdx = endIdx;
            }

            @Override
            ParsingStage doParse() {
                if (this.beginIdx == this.endIdx) {
                    throw new VertxException("Empty protocol", true);
                }
                String protocol = this.connectionUri.substring(this.beginIdx, this.endIdx).toLowerCase(Locale.ROOT);
                if (protocol.equals("ldap") || protocol.equals("ldaps")) {
                    throw new VertxException("LDAP Syntax is not supported", true);
                }
                if (protocol.equals("tcps")) {
                    this.configuration.put("ssl", (Object)true);
                } else if (!protocol.equals("tcp")) {
                    throw new VertxException("Unsupported protocol", true);
                }
                return this.hostOrIpV6(this.endIdx + 3);
            }
        }

        static class TnsAlias
        extends ParsingStage {
            final int endIdx;

            TnsAlias(String connectionUri, int beginIdx, int endIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
                this.endIdx = endIdx;
            }

            @Override
            ParsingStage doParse() {
                if (this.beginIdx == this.endIdx) {
                    throw new VertxException("Empty TNS alias", true);
                }
                this.configuration.put("tnsAlias", (Object)OracleConnectionUriParser.decodeUrl(this.connectionUri.substring(this.beginIdx, this.endIdx)));
                return this.endIdx == this.connectionUri.length() ? null : new ConnectionProps(this.connectionUri, this.endIdx + 1, this.configuration);
            }
        }

        static class UserAndPassword
        extends ParsingStage {
            UserAndPassword(String connectionUri, int beginIdx, JsonObject configuration) {
                super(connectionUri, beginIdx, configuration);
            }

            @Override
            ParsingStage doParse() {
                String userInfo;
                int i = this.connectionUri.indexOf(64, this.beginIdx);
                if (i < this.beginIdx) {
                    throw new VertxException("Did not find '@' sign", true);
                }
                if (i == this.beginIdx) {
                    return this.afterAtSign(this.beginIdx + 1);
                }
                String[] split = userInfo.split((userInfo = this.connectionUri.substring(this.beginIdx, i)).indexOf(47) >= 0 ? "/" : ":");
                if (split.length != 2) {
                    throw new VertxException("User and password must be provided or omitted", true);
                }
                String user = split[0];
                if (user.isEmpty()) {
                    throw new VertxException("User is missing", true);
                }
                String password = split[1];
                if (password.isEmpty()) {
                    throw new VertxException("Password is missing", true);
                }
                this.configuration.put("user", (Object)OracleConnectionUriParser.decodeUrl(user));
                this.configuration.put("password", (Object)OracleConnectionUriParser.decodeUrl(password));
                return this.afterAtSign(i + 1);
            }
        }
    }
}

