/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.impl.RowReader;
import io.vertx.oracleclient.impl.commands.OracleCommand;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import oracle.jdbc.OracleConnection;

public class OracleCursorFetchCommand<C, R>
extends OracleCommand<Boolean> {
    private final QueryResultHandler<R> resultHandler;
    private final int fetch;
    private final RowReader<C, R> rowReader;

    private OracleCursorFetchCommand(OracleConnection oracleConnection, ContextInternal connectionContext, ExtendedQueryCommand<R> cmd, RowReader<C, R> rowReader) {
        super(oracleConnection, connectionContext);
        this.resultHandler = cmd.resultHandler();
        this.fetch = cmd.fetch();
        this.rowReader = rowReader;
    }

    public static <U, V> OracleCursorFetchCommand<U, V> create(OracleConnection oracleConnection, ContextInternal connectionContext, ExtendedQueryCommand<V> cmd, RowReader<U, V> rowReader) {
        return new OracleCursorFetchCommand<U, V>(oracleConnection, connectionContext, cmd, rowReader);
    }

    @Override
    protected Future<Boolean> execute() {
        return this.rowReader.read(this.fetch).compose(oracleResponse -> {
            oracleResponse.handle(this.resultHandler);
            return this.rowReader.hasMore();
        });
    }
}

