/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.ServerMode;
import java.util.Base64;
import java.util.Map;

public class OracleConnectOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, OracleConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "instanceName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setInstanceName((String)member.getValue());
                    break;
                }
                case "serverMode": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServerMode(ServerMode.valueOf((String)member.getValue()));
                    break;
                }
                case "serviceId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServiceId((String)member.getValue());
                    break;
                }
                case "serviceName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServiceName((String)member.getValue());
                    break;
                }
                case "tnsAdmin": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTnsAdmin((String)member.getValue());
                    break;
                }
                case "tnsAlias": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTnsAlias((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(OracleConnectOptions obj, JsonObject json) {
        OracleConnectOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(OracleConnectOptions obj, Map<String, Object> json) {
        if (obj.getInstanceName() != null) {
            json.put("instanceName", obj.getInstanceName());
        }
        if (obj.getServerMode() != null) {
            json.put("serverMode", obj.getServerMode().name());
        }
        if (obj.getServiceId() != null) {
            json.put("serviceId", obj.getServiceId());
        }
        if (obj.getServiceName() != null) {
            json.put("serviceName", obj.getServiceName());
        }
        if (obj.getTnsAdmin() != null) {
            json.put("tnsAdmin", obj.getTnsAdmin());
        }
        if (obj.getTnsAlias() != null) {
            json.put("tnsAlias", obj.getTnsAlias());
        }
    }
}

