/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.OracleConnectionImpl;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.SqlConnection;
import java.util.Objects;

@VertxGen
public interface OracleConnection
extends SqlConnection {
    public static void connect(Vertx vertx, OracleConnectOptions connectOptions, Handler<AsyncResult<OracleConnection>> handler) {
        Objects.requireNonNull(handler);
        OracleConnectionImpl.connect(vertx, connectOptions).onComplete(handler);
    }

    public static Future<OracleConnection> connect(Vertx vertx, OracleConnectOptions connectOptions) {
        return OracleConnectionImpl.connect(vertx, connectOptions);
    }

    public static void connect(Vertx vertx, String connectionUri, Handler<AsyncResult<OracleConnection>> handler) {
        OracleConnection.connect(vertx, OracleConnectOptions.fromUri(connectionUri), handler);
    }

    public static Future<OracleConnection> connect(Vertx vertx, String connectionUri) {
        return OracleConnection.connect(vertx, OracleConnectOptions.fromUri(connectionUri));
    }

    @Fluent
    public OracleConnection prepare(String var1, Handler<AsyncResult<PreparedStatement>> var2);

    @Fluent
    public OracleConnection exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public OracleConnection closeHandler(Handler<Void> var1);

    public static OracleConnection cast(SqlConnection sqlConnection) {
        return (OracleConnection)sqlConnection;
    }
}

