/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.internal.ContextInternal;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.commands.OracleQueryCommand;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.command.SimpleQueryCommand;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.stream.Collector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class OracleSimpleQueryCommand<C, R>
extends OracleQueryCommand<C, R> {
    private final String sql;
    private final QueryResultHandler<R> resultHandler;

    private OracleSimpleQueryCommand(OracleConnection oracleConnection, ContextInternal connectionContext, SimpleQueryCommand<R> cmd, Collector<Row, C, R> collector) {
        super(oracleConnection, connectionContext, collector);
        this.sql = cmd.sql();
        this.resultHandler = cmd.resultHandler();
    }

    public static <U> OracleSimpleQueryCommand<?, U> create(OracleConnection oracleConnection, ContextInternal connectionContext, SimpleQueryCommand<U> cmd) {
        return new OracleSimpleQueryCommand(oracleConnection, connectionContext, cmd, cmd.collector());
    }

    @Override
    protected OraclePrepareOptions prepareOptions() {
        return null;
    }

    @Override
    protected boolean returnAutoGeneratedKeys(Connection conn, OraclePrepareOptions options) {
        return false;
    }

    @Override
    protected String query() {
        return this.sql;
    }

    @Override
    protected void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
    }

    @Override
    protected Future<Boolean> doExecute(OraclePreparedStatement ps, boolean returnAutoGeneratedKeys) {
        return this.executeBlocking(() -> ((OraclePreparedStatement)ps).executeAsyncOracle()).compose(pub -> this.first(pub)).compose(returnedResultSet -> this.executeBlocking(() -> this.decode((Statement)ps, (boolean)returnedResultSet, returnAutoGeneratedKeys))).map(oracleResponse -> {
            oracleResponse.handle(this.resultHandler);
            return false;
        });
    }
}

