/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import java.math.BigDecimal;
import java.math.BigInteger;

public class Money {
    private long integerPart;
    private int decimalPart;

    public Money(long integerPart, int decimalPart) {
        this.setIntegerPart(integerPart);
        this.setDecimalPart(decimalPart);
    }

    public Money(Number value) {
        if (value instanceof Double || value instanceof Float) {
            value = BigDecimal.valueOf((Double)value);
        }
        if (value instanceof BigDecimal) {
            BigInteger bd = ((BigDecimal)value).multiply(new BigDecimal(100)).toBigInteger();
            this.setIntegerPart(bd.divide(BigInteger.valueOf(100L)).longValueExact());
            this.setDecimalPart(bd.remainder(BigInteger.valueOf(100L)).abs().intValueExact());
        } else {
            this.setIntegerPart(value.longValue());
        }
    }

    public Money() {
    }

    public long getIntegerPart() {
        return this.integerPart;
    }

    public int getDecimalPart() {
        return this.decimalPart;
    }

    public Money setIntegerPart(long part) {
        if (part > 92233720368547758L || part < -92233720368547758L) {
            throw new IllegalArgumentException();
        }
        this.integerPart = part;
        return this;
    }

    public Money setDecimalPart(int part) {
        if (part > 99 || part < 0) {
            throw new IllegalArgumentException();
        }
        this.decimalPart = part;
        return this;
    }

    public BigDecimal bigDecimalValue() {
        BigDecimal value = new BigDecimal(this.integerPart).multiply(BigDecimal.valueOf(100L));
        value = this.integerPart >= 0L ? value.add(BigDecimal.valueOf(this.decimalPart)) : value.subtract(BigDecimal.valueOf(this.decimalPart));
        return value;
    }

    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Money that = (Money)o;
        return this.decimalPart == that.decimalPart && this.integerPart == that.integerPart;
    }

    public int hashCode() {
        return Long.valueOf(this.integerPart).hashCode() ^ Integer.valueOf(this.decimalPart).hashCode();
    }

    public String toString() {
        return "Money(" + this.integerPart + "." + this.decimalPart + ")";
    }
}

