/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PgDatabaseMetadata
implements DatabaseMetadata {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)(?:\\.(\\d+))?");
    private final String fullVersion;
    private int majorVersion;
    private int minorVersion;

    public PgDatabaseMetadata(String serverVersion) {
        this.fullVersion = serverVersion;
        Matcher matcher = VERSION_PATTERN.matcher(serverVersion);
        if (matcher.find()) {
            this.majorVersion = Integer.parseInt(matcher.group(1));
            String minorPart = matcher.group(2);
            if (minorPart != null) {
                this.minorVersion = Integer.parseInt(minorPart);
            }
        }
    }

    public String productName() {
        return "PostgreSQL";
    }

    public String fullVersion() {
        return this.fullVersion;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }
}

