/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.impl.ConnectionManager;

public class RedisClient
implements Redis {
    private final Context context;
    private final ConnectionManager connectionManager;
    private final String defaultAddress;

    public RedisClient(Vertx vertx, RedisOptions options) {
        this.context = vertx.getOrCreateContext();
        this.connectionManager = new ConnectionManager(vertx, options);
        this.defaultAddress = options.getEndpoint();
    }

    @Override
    public Redis connect(Handler<AsyncResult<RedisConnection>> onConnect) {
        this.connectionManager.getConnection(this.context, this.defaultAddress, null, onConnect);
        return this;
    }

    @Override
    public void close() {
        this.connectionManager.close();
    }
}

