/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.op;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@Deprecated
@DataObject
public class SortOptions {
    public static final SortOptions NONE = new SortOptions();
    private Long offset;
    private Long count;
    private String by;
    private List<String> getList = new LinkedList<String>();
    private Boolean descending;
    private Boolean alpha;
    private String store;

    public SortOptions() {
    }

    public SortOptions(SortOptions obj) {
        this.offset = obj.offset;
        this.count = obj.count;
        this.by = obj.by;
        this.getList.addAll(obj.getList);
        this.descending = obj.descending;
        this.alpha = obj.alpha;
        this.store = obj.store;
    }

    public SortOptions(JsonObject obj) {
        this.offset = obj.getLong("offset");
        this.count = obj.getLong("count");
        this.by = obj.getString("by");
        this.descending = obj.getBoolean("descending");
        this.alpha = obj.getBoolean("alpha");
        this.store = obj.getString("store");
        JsonArray list = obj.getJsonArray("get");
        if (list != null) {
            this.getList.addAll(list.getList());
        }
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        if (this.offset != null) {
            result.put("offset", this.offset);
            result.put("count", this.count);
        }
        if (this.by != null) {
            result.put("by", this.by);
        }
        if (this.getList.size() > 0) {
            result.put("get", new JsonArray(new ArrayList<String>(this.getList)));
        }
        if (this.descending != null) {
            result.put("descending", this.descending);
        }
        if (this.alpha != null) {
            result.put("alpha", this.alpha);
        }
        if (this.store != null) {
            result.put("store", this.store);
        }
        return result;
    }

    public SortOptions setLimit(long offset, long count) {
        this.offset = offset;
        this.count = count;
        return this;
    }

    public SortOptions setBy(String pattern) {
        this.by = pattern;
        return this;
    }

    public SortOptions addGet(String pattern) {
        this.getList.add(pattern);
        return this;
    }

    public SortOptions setDescending(Boolean descending) {
        this.descending = descending;
        return this;
    }

    public SortOptions useDescending() {
        this.descending = true;
        return this;
    }

    public SortOptions setAlpha(Boolean alpha) {
        this.alpha = alpha;
        return this;
    }

    public SortOptions useAlpha() {
        this.alpha = true;
        return this;
    }

    public SortOptions setStore(String store) {
        this.store = store;
        return this;
    }

    public JsonArray toJsonArray() {
        JsonArray result = new JsonArray();
        if (this.by != null) {
            result.add("BY");
            result.add(this.by);
        }
        if (this.offset != null) {
            result.add("LIMIT");
            result.add(this.offset);
            result.add(this.count);
        }
        for (String pattern : this.getList) {
            result.add("GET");
            result.add(pattern);
        }
        if (this.descending != null && this.descending.booleanValue()) {
            result.add("DESC");
        }
        if (this.alpha != null && this.alpha.booleanValue()) {
            result.add("ALPHA");
        }
        if (this.store != null) {
            result.add("STORE");
            result.add(this.store);
        }
        return result;
    }
}

