/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.redis.client.RedisConnectOptions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class RedisConnectOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "connectionString": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setConnectionString((String)member.getValue());
                    break;
                }
                case "connectionStrings": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addConnectionString((String)item);
                        }
                    });
                    break;
                }
                case "endpoint": {
                    break;
                }
                case "endpoints": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setEndpoints(list);
                    break;
                }
                case "maxNestedArrays": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxNestedArrays(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWaitingHandlers": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWaitingHandlers(((Number)member.getValue()).intValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "protocolNegotiation": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setProtocolNegotiation((Boolean)member.getValue());
                }
            }
        }
    }

    public static void toJson(RedisConnectOptions obj, JsonObject json) {
        RedisConnectOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(RedisConnectOptions obj, Map<String, Object> json) {
        if (obj.getEndpoint() != null) {
            json.put("endpoint", obj.getEndpoint());
        }
        if (obj.getEndpoints() != null) {
            JsonArray array = new JsonArray();
            obj.getEndpoints().forEach(item -> array.add(item));
            json.put("endpoints", array);
        }
        json.put("maxNestedArrays", obj.getMaxNestedArrays());
        json.put("maxWaitingHandlers", obj.getMaxWaitingHandlers());
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        json.put("protocolNegotiation", obj.isProtocolNegotiation());
    }
}

