/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import io.vertx.rx.java.RxHelper;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;

public class ObservableReadStream<T, R>
implements Observable.OnSubscribe<R> {
    private static final Throwable COMPLETED_SENTINEL = new Throwable();
    public static final long DEFAULT_MAX_BUFFER_SIZE = 256L;
    private final ReadStream<T> stream;
    private final Function<T, R> adapter;
    private final AtomicReference<Sub> subscription = new AtomicReference();
    private boolean subscribed;

    public ObservableReadStream(ReadStream<T> stream, Function<T, R> adapter) {
        this(stream, adapter, 256L);
    }

    public ObservableReadStream(ReadStream<T> stream, Function<T, R> adapter, long maxBufferSize) {
        stream.pause();
        this.stream = stream;
        this.adapter = adapter;
    }

    public long getRequested() {
        Sub sub = this.subscription.get();
        return sub != null ? sub.adapter.requested() : 0L;
    }

    public void call(Subscriber<? super R> subscriber) {
        QueueAdapter adapter = new QueueAdapter(subscriber);
        Sub sub = new Sub(adapter);
        if (!this.subscription.compareAndSet(null, sub)) {
            throw new IllegalStateException();
        }
        subscriber.setProducer((Producer)sub);
        subscriber.add((Subscription)sub);
        this.stream.exceptionHandler(sub.adapter::end);
        this.stream.endHandler(v -> sub.adapter.end(COMPLETED_SENTINEL));
        this.stream.handler((Handler)sub.adapter);
        this.subscribed = true;
        long requested = adapter.requested();
        this.stream.pause();
        if (requested > 0L) {
            this.stream.fetch(requested);
        }
    }

    private class QueueAdapter
    extends Adapter {
        QueueAdapter(Subscriber<? super R> subscriber) {
            super(subscriber);
        }

        @Override
        boolean dispose() {
            return true;
        }

        @Override
        void end(Throwable t) {
            if (t == COMPLETED_SENTINEL) {
                this.subscriber.onCompleted();
            } else {
                this.subscriber.onError(t);
            }
        }

        public void handle(T item) {
            this.subscriber.onNext(ObservableReadStream.this.adapter.apply(item));
        }

        @Override
        void request(long n) {
            super.request(n);
            if (ObservableReadStream.this.subscribed && n > 0L) {
                ObservableReadStream.this.stream.fetch(n);
            }
        }
    }

    private abstract class Adapter
    implements Handler<T> {
        protected final Subscriber<? super R> subscriber;
        long requested;

        Adapter(Subscriber<? super R> subscriber) {
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized long requested() {
            ObservableReadStream observableReadStream = ObservableReadStream.this;
            synchronized (observableReadStream) {
                return this.requested;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void request(long n) {
            ObservableReadStream observableReadStream = ObservableReadStream.this;
            synchronized (observableReadStream) {
                this.requested = n == Long.MAX_VALUE || n >= Long.MAX_VALUE - this.requested ? Long.MAX_VALUE : (this.requested += n);
            }
        }

        abstract boolean dispose();

        abstract void end(Throwable var1);
    }

    private class Sub
    implements Subscription,
    Producer {
        private Adapter adapter;

        Sub(Adapter queue) {
            this.adapter = queue;
        }

        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Cannot request negative items:" + n);
            }
            this.adapter.request(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsubscribe() {
            if (ObservableReadStream.this.subscription.compareAndSet(this, null)) {
                boolean resume;
                ObservableReadStream observableReadStream = ObservableReadStream.this;
                synchronized (observableReadStream) {
                    resume = this.adapter.dispose();
                }
                RxHelper.setNullHandlers(ObservableReadStream.this.stream);
                if (resume) {
                    try {
                        ObservableReadStream.this.stream.resume();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ObservableReadStream.this.subscribed = false;
            }
        }

        public boolean isUnsubscribed() {
            return ObservableReadStream.this.subscription.get() != this;
        }
    }
}

