/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
implements WriteStream<io.vertx.rxjava.core.buffer.Buffer>,
ReadStream<HttpClientResponse> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg(obj -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private Observable<HttpClientResponse> observable;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;
    private static final TypeArg<HttpClientResponse> TYPE_ARG_0 = new TypeArg(o1 -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;
    private HttpConnection cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        this.delegate = delegate;
    }

    public HttpClientRequest(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientRequest)delegate;
    }

    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<HttpClientResponse> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.http.HttpClientResponse, HttpClientResponse> conv = HttpClientResponse::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<HttpClientResponse> pipe() {
        Pipe<HttpClientResponse> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<HttpClientResponse> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<HttpClientResponse> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> pipeToObservable(WriteStream<HttpClientResponse> dst) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxPipeTo(WriteStream<HttpClientResponse> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientRequest write(io.vertx.rxjava.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public HttpClientRequest write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(io.vertx.rxjava.core.buffer.Buffer data) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(data, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(data, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Deprecated
    public HttpClientRequest handler(final Handler<HttpClientResponse> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                handler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    @Deprecated
    public HttpClientRequest pause() {
        this.delegate.pause();
        return this;
    }

    @Deprecated
    public HttpClientRequest resume() {
        this.delegate.resume();
        return this;
    }

    @Deprecated
    public HttpClientRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Deprecated
    public HttpClientRequest endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public String getRawMethod() {
        String ret = this.delegate.getRawMethod();
        return ret;
    }

    public HttpClientRequest setRawMethod(String method) {
        this.delegate.setRawMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest write(String chunk) {
        this.delegate.write(chunk);
        return this;
    }

    public HttpClientRequest write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(String chunk) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(chunk, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(String chunk) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest write(String chunk, String enc) {
        this.delegate.write(chunk, enc);
        return this;
    }

    public HttpClientRequest write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, enc, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(String chunk, String enc) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(chunk, enc, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(String chunk, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest sendHead() {
        this.delegate.sendHead();
        return this;
    }

    public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
        this.delegate.sendHead(completionHandler);
        return this;
    }

    @Override
    public void end(String chunk) {
        this.delegate.end(chunk);
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, handler);
    }

    @Deprecated
    public Observable<Void> endObservable(String chunk) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(chunk, handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd(String chunk) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public void end(String chunk, String enc) {
        this.delegate.end(chunk, enc);
    }

    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, enc, handler);
    }

    @Deprecated
    public Observable<Void> endObservable(String chunk, String enc) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(chunk, enc, handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd(String chunk, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk) {
        this.delegate.end(chunk.getDelegate());
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> endObservable(io.vertx.rxjava.core.buffer.Buffer chunk) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(chunk, handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer chunk) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Deprecated
    public Observable<Void> endObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest setTimeout(long timeoutMs) {
        this.delegate.setTimeout(timeoutMs);
        return this;
    }

    public HttpClientRequest pushHandler(final Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler((Handler)new Handler<io.vertx.core.http.HttpClientRequest>(){

            public void handle(io.vertx.core.http.HttpClientRequest event) {
                handler.handle((Object)HttpClientRequest.newInstance(event));
            }
        });
        return this;
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    @Deprecated
    public HttpClientRequest connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest writeCustomFrame(int type, int flags, io.vertx.rxjava.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

