/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.file;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.OpenOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.file.AsyncFile;
import io.vertx.rxjava.core.file.FileProps;
import io.vertx.rxjava.core.file.FileSystemProps;
import java.util.List;
import rx.Single;

@RxGen(value=io.vertx.core.file.FileSystem.class)
public class FileSystem {
    public static final TypeArg<FileSystem> __TYPE_ARG = new TypeArg(obj -> new FileSystem((io.vertx.core.file.FileSystem)obj), FileSystem::getDelegate);
    private final io.vertx.core.file.FileSystem delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem that = (FileSystem)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    public FileSystem(Object delegate) {
        this.delegate = (io.vertx.core.file.FileSystem)delegate;
    }

    public io.vertx.core.file.FileSystem getDelegate() {
        return this.delegate;
    }

    public FileSystem copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, handler);
        return this;
    }

    public FileSystem copy(String from, String to) {
        return this.copy(from, to, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCopy(String from, String to) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.copy(from, to, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem copy(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, options, handler);
        return this;
    }

    public FileSystem copy(String from, String to, CopyOptions options) {
        return this.copy(from, to, options, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCopy(String from, String to, CopyOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.copy(from, to, options, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    public FileSystem copyRecursive(String from, String to, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.delegate.copyRecursive(from, to, recursive, handler);
        return this;
    }

    public FileSystem copyRecursive(String from, String to, boolean recursive) {
        return this.copyRecursive(from, to, recursive, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCopyRecursive(String from, String to, boolean recursive) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.copyRecursive(from, to, recursive, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.delegate.copyRecursiveBlocking(from, to, recursive);
        return this;
    }

    public FileSystem move(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, handler);
        return this;
    }

    public FileSystem move(String from, String to) {
        return this.move(from, to, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxMove(String from, String to) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.move(from, to, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem move(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, options, handler);
        return this;
    }

    public FileSystem move(String from, String to, CopyOptions options) {
        return this.move(from, to, options, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxMove(String from, String to, CopyOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.move(from, to, options, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    public FileSystem truncate(String path, long len, Handler<AsyncResult<Void>> handler) {
        this.delegate.truncate(path, len, handler);
        return this;
    }

    public FileSystem truncate(String path, long len) {
        return this.truncate(path, len, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxTruncate(String path, long len) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.truncate(path, len, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem truncateBlocking(String path, long len) {
        this.delegate.truncateBlocking(path, len);
        return this;
    }

    public FileSystem chmod(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmod(path, perms, handler);
        return this;
    }

    public FileSystem chmod(String path, String perms) {
        return this.chmod(path, perms, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxChmod(String path, String perms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.chmod(path, perms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem chmodBlocking(String path, String perms) {
        this.delegate.chmodBlocking(path, perms);
        return this;
    }

    public FileSystem chmodRecursive(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmodRecursive(path, perms, dirPerms, handler);
        return this;
    }

    public FileSystem chmodRecursive(String path, String perms, String dirPerms) {
        return this.chmodRecursive(path, perms, dirPerms, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxChmodRecursive(String path, String perms, String dirPerms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.chmodRecursive(path, perms, dirPerms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path, perms, dirPerms);
        return this;
    }

    public FileSystem chown(String path, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.delegate.chown(path, user, group, handler);
        return this;
    }

    public FileSystem chown(String path, String user, String group) {
        return this.chown(path, user, group, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxChown(String path, String user, String group) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.chown(path, user, group, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem chownBlocking(String path, String user, String group) {
        this.delegate.chownBlocking(path, user, group);
        return this;
    }

    public FileSystem props(String path, Handler<AsyncResult<FileProps>> handler) {
        this.delegate.props(path, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> FileProps.newInstance(event))));
        return this;
    }

    public FileSystem props(String path) {
        return this.props(path, (Handler<AsyncResult<FileProps>>)((Handler)ar -> {}));
    }

    public Single<FileProps> rxProps(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.props(path, (Handler<AsyncResult<FileProps>>)fut)));
    }

    public FileProps propsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.propsBlocking(path));
        return ret;
    }

    public FileSystem lprops(String path, Handler<AsyncResult<FileProps>> handler) {
        this.delegate.lprops(path, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> FileProps.newInstance(event))));
        return this;
    }

    public FileSystem lprops(String path) {
        return this.lprops(path, (Handler<AsyncResult<FileProps>>)((Handler)ar -> {}));
    }

    public Single<FileProps> rxLprops(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lprops(path, (Handler<AsyncResult<FileProps>>)fut)));
    }

    public FileProps lpropsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.lpropsBlocking(path));
        return ret;
    }

    public FileSystem link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.link(link, existing, handler);
        return this;
    }

    public FileSystem link(String link, String existing) {
        return this.link(link, existing, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxLink(String link, String existing) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.link(link, existing, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    public FileSystem symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.symlink(link, existing, handler);
        return this;
    }

    public FileSystem symlink(String link, String existing) {
        return this.symlink(link, existing, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSymlink(String link, String existing) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.symlink(link, existing, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    public FileSystem unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.delegate.unlink(link, handler);
        return this;
    }

    public FileSystem unlink(String link) {
        return this.unlink(link, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxUnlink(String link) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.unlink(link, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    public FileSystem readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.delegate.readSymlink(link, handler);
        return this;
    }

    public FileSystem readSymlink(String link) {
        return this.readSymlink(link, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxReadSymlink(String link) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.readSymlink(link, (Handler<AsyncResult<String>>)fut)));
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    public FileSystem delete(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.delete(path, handler);
        return this;
    }

    public FileSystem delete(String path) {
        return this.delete(path, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxDelete(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.delete(path, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem deleteBlocking(String path) {
        this.delegate.deleteBlocking(path);
        return this;
    }

    public FileSystem deleteRecursive(String path, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.delegate.deleteRecursive(path, recursive, handler);
        return this;
    }

    public FileSystem deleteRecursive(String path, boolean recursive) {
        return this.deleteRecursive(path, recursive, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxDeleteRecursive(String path, boolean recursive) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.deleteRecursive(path, recursive, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.delegate.deleteRecursiveBlocking(path, recursive);
        return this;
    }

    public FileSystem mkdir(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path, handler);
        return this;
    }

    public FileSystem mkdir(String path) {
        return this.mkdir(path, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxMkdir(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mkdir(path, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem mkdirBlocking(String path) {
        this.delegate.mkdirBlocking(path);
        return this;
    }

    public FileSystem mkdir(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path, perms, handler);
        return this;
    }

    public FileSystem mkdir(String path, String perms) {
        return this.mkdir(path, perms, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxMkdir(String path, String perms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mkdir(path, perms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem mkdirBlocking(String path, String perms) {
        this.delegate.mkdirBlocking(path, perms);
        return this;
    }

    public FileSystem mkdirs(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path, handler);
        return this;
    }

    public FileSystem mkdirs(String path) {
        return this.mkdirs(path, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxMkdirs(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mkdirs(path, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem mkdirsBlocking(String path) {
        this.delegate.mkdirsBlocking(path);
        return this;
    }

    public FileSystem mkdirs(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path, perms, handler);
        return this;
    }

    public FileSystem mkdirs(String path, String perms) {
        return this.mkdirs(path, perms, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxMkdirs(String path, String perms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mkdirs(path, perms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem mkdirsBlocking(String path, String perms) {
        this.delegate.mkdirsBlocking(path, perms);
        return this;
    }

    public FileSystem readDir(String path, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path, handler);
        return this;
    }

    public FileSystem readDir(String path) {
        return this.readDir(path, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxReadDir(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.readDir(path, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public List<String> readDirBlocking(String path) {
        List ret = this.delegate.readDirBlocking(path);
        return ret;
    }

    public FileSystem readDir(String path, String filter, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path, filter, handler);
        return this;
    }

    public FileSystem readDir(String path, String filter) {
        return this.readDir(path, filter, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxReadDir(String path, String filter) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.readDir(path, filter, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public List<String> readDirBlocking(String path, String filter) {
        List ret = this.delegate.readDirBlocking(path, filter);
        return ret;
    }

    public FileSystem readFile(String path, Handler<AsyncResult<Buffer>> handler) {
        this.delegate.readFile(path, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> Buffer.newInstance(event))));
        return this;
    }

    public FileSystem readFile(String path) {
        return this.readFile(path, (Handler<AsyncResult<Buffer>>)((Handler)ar -> {}));
    }

    public Single<Buffer> rxReadFile(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.readFile(path, (Handler<AsyncResult<Buffer>>)fut)));
    }

    public Buffer readFileBlocking(String path) {
        Buffer ret = Buffer.newInstance(this.delegate.readFileBlocking(path));
        return ret;
    }

    public FileSystem writeFile(String path, Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFile(path, data.getDelegate(), handler);
        return this;
    }

    public FileSystem writeFile(String path, Buffer data) {
        return this.writeFile(path, data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxWriteFile(String path, Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.writeFile(path, data, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem writeFileBlocking(String path, Buffer data) {
        this.delegate.writeFileBlocking(path, data.getDelegate());
        return this;
    }

    public FileSystem open(String path, OpenOptions options, Handler<AsyncResult<AsyncFile>> handler) {
        this.delegate.open(path, options, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> AsyncFile.newInstance(event))));
        return this;
    }

    public FileSystem open(String path, OpenOptions options) {
        return this.open(path, options, (Handler<AsyncResult<AsyncFile>>)((Handler)ar -> {}));
    }

    public Single<AsyncFile> rxOpen(String path, OpenOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.open(path, options, (Handler<AsyncResult<AsyncFile>>)fut)));
    }

    public AsyncFile openBlocking(String path, OpenOptions options) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path, options));
        return ret;
    }

    public FileSystem createFile(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path, handler);
        return this;
    }

    public FileSystem createFile(String path) {
        return this.createFile(path, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCreateFile(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createFile(path, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem createFileBlocking(String path) {
        this.delegate.createFileBlocking(path);
        return this;
    }

    public FileSystem createFile(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path, perms, handler);
        return this;
    }

    public FileSystem createFile(String path, String perms) {
        return this.createFile(path, perms, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCreateFile(String path, String perms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createFile(path, perms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem createFileBlocking(String path, String perms) {
        this.delegate.createFileBlocking(path, perms);
        return this;
    }

    public FileSystem exists(String path, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.exists(path, handler);
        return this;
    }

    public FileSystem exists(String path) {
        return this.exists(path, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxExists(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exists(path, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public boolean existsBlocking(String path) {
        boolean ret = this.delegate.existsBlocking(path);
        return ret;
    }

    public FileSystem fsProps(String path, Handler<AsyncResult<FileSystemProps>> handler) {
        this.delegate.fsProps(path, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> FileSystemProps.newInstance(event))));
        return this;
    }

    public FileSystem fsProps(String path) {
        return this.fsProps(path, (Handler<AsyncResult<FileSystemProps>>)((Handler)ar -> {}));
    }

    public Single<FileSystemProps> rxFsProps(String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.fsProps(path, (Handler<AsyncResult<FileSystemProps>>)fut)));
    }

    public FileSystemProps fsPropsBlocking(String path) {
        FileSystemProps ret = FileSystemProps.newInstance(this.delegate.fsPropsBlocking(path));
        return ret;
    }

    public FileSystem createTempDirectory(String prefix, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(prefix, handler);
        return this;
    }

    public FileSystem createTempDirectory(String prefix) {
        return this.createTempDirectory(prefix, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxCreateTempDirectory(String prefix) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createTempDirectory(prefix, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempDirectoryBlocking(String prefix) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix);
        return ret;
    }

    public FileSystem createTempDirectory(String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(prefix, perms, handler);
        return this;
    }

    public FileSystem createTempDirectory(String prefix, String perms) {
        return this.createTempDirectory(prefix, perms, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxCreateTempDirectory(String prefix, String perms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createTempDirectory(prefix, perms, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempDirectoryBlocking(String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix, perms);
        return ret;
    }

    public FileSystem createTempDirectory(String dir, String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(dir, prefix, perms, handler);
        return this;
    }

    public FileSystem createTempDirectory(String dir, String prefix, String perms) {
        return this.createTempDirectory(dir, prefix, perms, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxCreateTempDirectory(String dir, String prefix, String perms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createTempDirectory(dir, prefix, perms, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(dir, prefix, perms);
        return ret;
    }

    public FileSystem createTempFile(String prefix, String suffix, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(prefix, suffix, handler);
        return this;
    }

    public FileSystem createTempFile(String prefix, String suffix) {
        return this.createTempFile(prefix, suffix, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createTempFile(prefix, suffix, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempFileBlocking(String prefix, String suffix) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix);
        return ret;
    }

    public FileSystem createTempFile(String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(prefix, suffix, perms, handler);
        return this;
    }

    public FileSystem createTempFile(String prefix, String suffix, String perms) {
        return this.createTempFile(prefix, suffix, perms, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix, String perms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createTempFile(prefix, suffix, perms, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix, perms);
        return ret;
    }

    public FileSystem createTempFile(String dir, String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(dir, prefix, suffix, perms, handler);
        return this;
    }

    public FileSystem createTempFile(String dir, String prefix, String suffix, String perms) {
        return this.createTempFile(dir, prefix, suffix, perms, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxCreateTempFile(String dir, String prefix, String suffix, String perms) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createTempFile(dir, prefix, suffix, perms, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(dir, prefix, suffix, perms);
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

