/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.web.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ReadStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.ext.web.client.HttpResponse;
import io.vertx.rxjava.ext.web.client.predicate.ResponsePredicate;
import io.vertx.rxjava.ext.web.client.predicate.ResponsePredicateResult;
import io.vertx.rxjava.ext.web.codec.BodyCodec;
import io.vertx.rxjava.ext.web.multipart.MultipartForm;
import io.vertx.rxjava.uritemplate.Variables;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.web.client.HttpRequest.class)
public class HttpRequest<T> {
    public static final TypeArg<HttpRequest> __TYPE_ARG = new TypeArg(obj -> new HttpRequest((io.vertx.ext.web.client.HttpRequest)obj), HttpRequest::getDelegate);
    private final io.vertx.ext.web.client.HttpRequest<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private static final TypeArg<ResponsePredicate> TYPE_ARG_0 = new TypeArg(o1 -> ResponsePredicate.newInstance((io.vertx.ext.web.client.predicate.ResponsePredicate)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public HttpRequest(Object delegate, TypeArg<T> typeArg_0) {
        this.delegate = (io.vertx.ext.web.client.HttpRequest)delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.ext.web.client.HttpRequest getDelegate() {
        return this.delegate;
    }

    public HttpRequest<T> method(HttpMethod value) {
        this.delegate.method(value);
        return this;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public HttpRequest<T> port(int value) {
        this.delegate.port(value);
        return this;
    }

    public int port() {
        int ret = this.delegate.port();
        return ret;
    }

    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        HttpRequest ret = HttpRequest.newInstance(this.delegate.as(responseCodec.getDelegate()), responseCodec.__typeArg_0);
        return ret;
    }

    public BodyCodec<T> bodyCodec() {
        BodyCodec<T> ret = BodyCodec.newInstance(this.delegate.bodyCodec(), this.__typeArg_0);
        return ret;
    }

    public HttpRequest<T> host(String value) {
        this.delegate.host(value);
        return this;
    }

    public String host() {
        String ret = this.delegate.host();
        return ret;
    }

    public HttpRequest<T> virtualHost(String value) {
        this.delegate.virtualHost(value);
        return this;
    }

    public String virtualHost() {
        String ret = this.delegate.virtualHost();
        return ret;
    }

    public HttpRequest<T> uri(String value) {
        this.delegate.uri(value);
        return this;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public HttpRequest<T> putHeaders(MultiMap headers) {
        this.delegate.putHeaders(headers.getDelegate());
        return this;
    }

    public HttpRequest<T> putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpRequest<T> basicAuthentication(String id, String password) {
        this.delegate.basicAuthentication(id, password);
        return this;
    }

    public HttpRequest<T> basicAuthentication(Buffer id, Buffer password) {
        this.delegate.basicAuthentication(id.getDelegate(), password.getDelegate());
        return this;
    }

    public HttpRequest<T> bearerTokenAuthentication(String bearerToken) {
        this.delegate.bearerTokenAuthentication(bearerToken);
        return this;
    }

    public HttpRequest<T> ssl(Boolean value) {
        this.delegate.ssl(value);
        return this;
    }

    public Boolean ssl() {
        Boolean ret = this.delegate.ssl();
        return ret;
    }

    public HttpRequest<T> timeout(long value) {
        this.delegate.timeout(value);
        return this;
    }

    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.delegate.addQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.delegate.setQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setTemplateParam(String paramName, String paramValue) {
        this.delegate.setTemplateParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setTemplateParam(String paramName, List<String> paramValue) {
        this.delegate.setTemplateParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setTemplateParam(String paramName, Map<String, String> paramValue) {
        this.delegate.setTemplateParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> followRedirects(boolean value) {
        this.delegate.followRedirects(value);
        return this;
    }

    public boolean followRedirects() {
        boolean ret = this.delegate.followRedirects();
        return ret;
    }

    public HttpRequest<T> proxy(ProxyOptions proxyOptions) {
        this.delegate.proxy(proxyOptions);
        return this;
    }

    public ProxyOptions proxy() {
        ProxyOptions ret = this.delegate.proxy();
        return ret;
    }

    public HttpRequest<T> expect(final Function<HttpResponse<Void>, ResponsePredicateResult> predicate) {
        this.delegate.expect((Function)new Function<io.vertx.ext.web.client.HttpResponse<Void>, io.vertx.ext.web.client.predicate.ResponsePredicateResult>(){

            @Override
            public io.vertx.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.ext.web.client.HttpResponse<Void> arg) {
                ResponsePredicateResult ret = (ResponsePredicateResult)predicate.apply(HttpResponse.newInstance(arg, TypeArg.unknown()));
                return ret.getDelegate();
            }
        });
        return this;
    }

    public HttpRequest<T> expect(ResponsePredicate predicate) {
        this.delegate.expect(predicate.getDelegate());
        return this;
    }

    public List<ResponsePredicate> expectations() {
        List<ResponsePredicate> ret = this.delegate.expectations().stream().map(elt -> ResponsePredicate.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    public MultiMap queryParams() {
        MultiMap ret = MultiMap.newInstance(this.delegate.queryParams());
        return ret;
    }

    public Variables templateParams() {
        Variables ret = Variables.newInstance(this.delegate.templateParams());
        return ret;
    }

    public HttpRequest<T> copy() {
        HttpRequest<T> ret = HttpRequest.newInstance(this.delegate.copy(), this.__typeArg_0);
        return ret;
    }

    public HttpRequest<T> multipartMixed(boolean allow) {
        this.delegate.multipartMixed(allow);
        return this;
    }

    public boolean multipartMixed() {
        boolean ret = this.delegate.multipartMixed();
        return ret;
    }

    public HttpRequest<T> traceOperation(String traceOperation) {
        this.delegate.traceOperation(traceOperation);
        return this;
    }

    public String traceOperation() {
        String ret = this.delegate.traceOperation();
        return ret;
    }

    public void sendStream(ReadStream<Buffer> body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream(body.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void sendStream(ReadStream<Buffer> body) {
        this.sendStream(body, ar -> {});
    }

    public Single<HttpResponse<T>> rxSendStream(ReadStream<Buffer> body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public void sendStream(Observable<Buffer> body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream(ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void sendStream(Observable<Buffer> body) {
        this.sendStream(body, ar -> {});
    }

    public Single<HttpResponse<T>> rxSendStream(Observable<Buffer> body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public void sendBuffer(Buffer body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendBuffer(body.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void sendBuffer(Buffer body) {
        this.sendBuffer(body, ar -> {});
    }

    public Single<HttpResponse<T>> rxSendBuffer(Buffer body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendBuffer(body, (Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public void sendJsonObject(JsonObject body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendJsonObject(body, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void sendJsonObject(JsonObject body) {
        this.sendJsonObject(body, ar -> {});
    }

    public Single<HttpResponse<T>> rxSendJsonObject(JsonObject body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendJsonObject(body, (Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public void sendJson(Object body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendJson(body, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void sendJson(Object body) {
        this.sendJson(body, ar -> {});
    }

    public Single<HttpResponse<T>> rxSendJson(Object body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendJson(body, (Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public void sendForm(MultiMap body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendForm(body.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void sendForm(MultiMap body) {
        this.sendForm(body, ar -> {});
    }

    public Single<HttpResponse<T>> rxSendForm(MultiMap body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendForm(body, (Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public void sendForm(MultiMap body, String charset, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendForm(body.getDelegate(), charset, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void sendForm(MultiMap body, String charset) {
        this.sendForm(body, charset, ar -> {});
    }

    public Single<HttpResponse<T>> rxSendForm(MultiMap body, String charset) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendForm(body, charset, (Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public void sendMultipartForm(MultipartForm body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendMultipartForm(body.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void sendMultipartForm(MultipartForm body) {
        this.sendMultipartForm(body, ar -> {});
    }

    public Single<HttpResponse<T>> rxSendMultipartForm(MultipartForm body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendMultipartForm(body, (Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public void send(Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.send((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpResponse.newInstance(event, this.__typeArg_0))));
    }

    public void send() {
        this.send(ar -> {});
    }

    public Single<HttpResponse<T>> rxSend() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send((Handler<AsyncResult<HttpResponse<T>>>)fut)));
    }

    public HttpRequest<T> putHeader(String name, Iterable<String> value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpRequest<T> authentication(Credentials credentials) {
        this.delegate.authentication(credentials);
        return this;
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg) {
        return arg != null ? new HttpRequest<T>(arg) : null;
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new HttpRequest<T>(arg, __typeArg_T) : null;
    }
}

