/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava.Helper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.ext.mongo.MongoGridFsClient;
import java.util.List;
import rx.Single;

@RxGen(value=io.vertx.ext.mongo.MongoClient.class)
public class MongoClient
implements RxDelegate {
    public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg(obj -> new MongoClient((io.vertx.ext.mongo.MongoClient)obj), MongoClient::getDelegate);
    private final io.vertx.ext.mongo.MongoClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClient that = (MongoClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
        this.delegate = delegate;
    }

    public MongoClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
    }

    public io.vertx.ext.mongo.MongoClient getDelegate() {
        return this.delegate;
    }

    public static MongoClient create(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.create((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public static MongoClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config, String dataSourceName) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config, (String)dataSourceName));
        return ret;
    }

    public static MongoClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public MongoClient save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.save(collection, document, resultHandler);
        return this;
    }

    public MongoClient save(String collection, JsonObject document) {
        return this.save(collection, document, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxSave(String collection, JsonObject document) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.save(collection, document, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.saveWithOptions(collection, document, writeOption, resultHandler);
        return this;
    }

    public MongoClient saveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return this.saveWithOptions(collection, document, writeOption, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxSaveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.saveWithOptions(collection, document, writeOption, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.insert(collection, document, resultHandler);
        return this;
    }

    public MongoClient insert(String collection, JsonObject document) {
        return this.insert(collection, document, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxInsert(String collection, JsonObject document) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.insert(collection, document, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.insertWithOptions(collection, document, writeOption, resultHandler);
        return this;
    }

    public MongoClient insertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return this.insertWithOptions(collection, document, writeOption, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxInsertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.insertWithOptions(collection, document, writeOption, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollection(collection, query, update, resultHandler);
        return this;
    }

    public MongoClient updateCollection(String collection, JsonObject query, JsonObject update) {
        return this.updateCollection(collection, query, update, (Handler<AsyncResult<MongoClientUpdateResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateCollection(collection, query, update, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient updateCollection(String collection, JsonObject query, JsonArray update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollection(collection, query, update, resultHandler);
        return this;
    }

    public MongoClient updateCollection(String collection, JsonObject query, JsonArray update) {
        return this.updateCollection(collection, query, update, (Handler<AsyncResult<MongoClientUpdateResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonArray update) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateCollection(collection, query, update, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
        return this;
    }

    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return this.updateCollectionWithOptions(collection, query, update, options, (Handler<AsyncResult<MongoClientUpdateResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateCollectionWithOptions(collection, query, update, options, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
        return this;
    }

    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        return this.updateCollectionWithOptions(collection, query, update, options, (Handler<AsyncResult<MongoClientUpdateResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateCollectionWithOptions(collection, query, update, options, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.replaceDocuments(collection, query, replace, resultHandler);
        return this;
    }

    public MongoClient replaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return this.replaceDocuments(collection, query, replace, (Handler<AsyncResult<MongoClientUpdateResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.replaceDocuments(collection, query, replace, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
        return this;
    }

    public MongoClient replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return this.replaceDocumentsWithOptions(collection, query, replace, options, (Handler<AsyncResult<MongoClientUpdateResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.replaceDocumentsWithOptions(collection, query, replace, options, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient bulkWrite(String collection, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.delegate.bulkWrite(collection, operations, resultHandler);
        return this;
    }

    public MongoClient bulkWrite(String collection, List<BulkOperation> operations) {
        return this.bulkWrite(collection, operations, (Handler<AsyncResult<MongoClientBulkWriteResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientBulkWriteResult> rxBulkWrite(String collection, List<BulkOperation> operations) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bulkWrite(collection, operations, (Handler<AsyncResult<MongoClientBulkWriteResult>>)fut)));
    }

    public MongoClient bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
        return this;
    }

    public MongoClient bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return this.bulkWriteWithOptions(collection, operations, bulkWriteOptions, (Handler<AsyncResult<MongoClientBulkWriteResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bulkWriteWithOptions(collection, operations, bulkWriteOptions, (Handler<AsyncResult<MongoClientBulkWriteResult>>)fut)));
    }

    public MongoClient find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.delegate.find(collection, query, resultHandler);
        return this;
    }

    public MongoClient find(String collection, JsonObject query) {
        return this.find(collection, query, (Handler<AsyncResult<List<JsonObject>>>)((Handler)ar -> {}));
    }

    public Single<List<JsonObject>> rxFind(String collection, JsonObject query) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.find(collection, query, (Handler<AsyncResult<List<JsonObject>>>)fut)));
    }

    public ReadStream<JsonObject> findBatch(String collection, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatch(collection, query), TypeArg.unknown());
        return ret;
    }

    public MongoClient findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.delegate.findWithOptions(collection, query, options, resultHandler);
        return this;
    }

    public MongoClient findWithOptions(String collection, JsonObject query, FindOptions options) {
        return this.findWithOptions(collection, query, options, (Handler<AsyncResult<List<JsonObject>>>)((Handler)ar -> {}));
    }

    public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, FindOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findWithOptions(collection, query, options, (Handler<AsyncResult<List<JsonObject>>>)fut)));
    }

    public ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatchWithOptions(collection, query, options), TypeArg.unknown());
        return ret;
    }

    public MongoClient findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOne(collection, query, fields, resultHandler);
        return this;
    }

    public MongoClient findOne(String collection, JsonObject query, JsonObject fields) {
        return this.findOne(collection, query, fields, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findOne(collection, query, fields, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndUpdate(collection, query, update, resultHandler);
        return this;
    }

    public MongoClient findOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return this.findOneAndUpdate(collection, query, update, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findOneAndUpdate(collection, query, update, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
        return this;
    }

    public MongoClient findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndReplace(collection, query, replace, resultHandler);
        return this;
    }

    public MongoClient findOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return this.findOneAndReplace(collection, query, replace, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findOneAndReplace(collection, query, replace, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler);
        return this;
    }

    public MongoClient findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        return this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndDelete(collection, query, resultHandler);
        return this;
    }

    public MongoClient findOneAndDelete(String collection, JsonObject query) {
        return this.findOneAndDelete(collection, query, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findOneAndDelete(collection, query, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
        return this;
    }

    public MongoClient findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        return this.findOneAndDeleteWithOptions(collection, query, findOptions, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findOneAndDeleteWithOptions(collection, query, findOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.count(collection, query, resultHandler);
        return this;
    }

    public MongoClient count(String collection, JsonObject query) {
        return this.count(collection, query, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxCount(String collection, JsonObject query) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.count(collection, query, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoClient countWithOptions(String collection, JsonObject query, CountOptions countOptions, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.countWithOptions(collection, query, countOptions, resultHandler);
        return this;
    }

    public MongoClient countWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        return this.countWithOptions(collection, query, countOptions, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxCountWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.countWithOptions(collection, query, countOptions, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoClient removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocuments(collection, query, resultHandler);
        return this;
    }

    public MongoClient removeDocuments(String collection, JsonObject query) {
        return this.removeDocuments(collection, query, (Handler<AsyncResult<MongoClientDeleteResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.removeDocuments(collection, query, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    public MongoClient removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return this.removeDocumentsWithOptions(collection, query, writeOption, (Handler<AsyncResult<MongoClientDeleteResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.removeDocumentsWithOptions(collection, query, writeOption, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocument(collection, query, resultHandler);
        return this;
    }

    public MongoClient removeDocument(String collection, JsonObject query) {
        return this.removeDocument(collection, query, (Handler<AsyncResult<MongoClientDeleteResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.removeDocument(collection, query, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    public MongoClient removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return this.removeDocumentWithOptions(collection, query, writeOption, (Handler<AsyncResult<MongoClientDeleteResult>>)((Handler)ar -> {}));
    }

    public Single<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.removeDocumentWithOptions(collection, query, writeOption, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createCollection(collectionName, resultHandler);
        return this;
    }

    public MongoClient createCollection(String collectionName) {
        return this.createCollection(collectionName, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCreateCollection(String collectionName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createCollection(collectionName, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createCollectionWithOptions(collectionName, collectionOptions, resultHandler);
        return this;
    }

    public MongoClient createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        return this.createCollectionWithOptions(collectionName, collectionOptions, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCreateCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createCollectionWithOptions(collectionName, collectionOptions, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.getCollections(resultHandler);
        return this;
    }

    public MongoClient getCollections() {
        return this.getCollections((Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxGetCollections() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getCollections((Handler<AsyncResult<List<String>>>)fut)));
    }

    public MongoClient dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.dropCollection(collection, resultHandler);
        return this;
    }

    public MongoClient dropCollection(String collection) {
        return this.dropCollection(collection, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxDropCollection(String collection) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.dropCollection(collection, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndex(collection, key, resultHandler);
        return this;
    }

    public MongoClient createIndex(String collection, JsonObject key) {
        return this.createIndex(collection, key, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCreateIndex(String collection, JsonObject key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createIndex(collection, key, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndexWithOptions(collection, key, options, resultHandler);
        return this;
    }

    public MongoClient createIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        return this.createIndexWithOptions(collection, key, options, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCreateIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createIndexWithOptions(collection, key, options, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createIndexes(String collection, List<IndexModel> indexes, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndexes(collection, indexes, resultHandler);
        return this;
    }

    public MongoClient createIndexes(String collection, List<IndexModel> indexes) {
        return this.createIndexes(collection, indexes, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCreateIndexes(String collection, List<IndexModel> indexes) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createIndexes(collection, indexes, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.listIndexes(collection, resultHandler);
        return this;
    }

    public MongoClient listIndexes(String collection) {
        return this.listIndexes(collection, (Handler<AsyncResult<JsonArray>>)((Handler)ar -> {}));
    }

    public Single<JsonArray> rxListIndexes(String collection) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.listIndexes(collection, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.dropIndex(collection, indexName, resultHandler);
        return this;
    }

    public MongoClient dropIndex(String collection, String indexName) {
        return this.dropIndex(collection, indexName, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxDropIndex(String collection, String indexName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.dropIndex(collection, indexName, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.runCommand(commandName, command, resultHandler);
        return this;
    }

    public MongoClient runCommand(String commandName, JsonObject command) {
        return this.runCommand(commandName, command, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxRunCommand(String commandName, JsonObject command) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.runCommand(commandName, command, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinct(collection, fieldName, resultClassname, resultHandler);
        return this;
    }

    public MongoClient distinct(String collection, String fieldName, String resultClassname) {
        return this.distinct(collection, fieldName, resultClassname, (Handler<AsyncResult<JsonArray>>)((Handler)ar -> {}));
    }

    public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.distinct(collection, fieldName, resultClassname, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient distinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinct(collection, fieldName, resultClassname, distinctOptions, resultHandler);
        return this;
    }

    public MongoClient distinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return this.distinct(collection, fieldName, resultClassname, distinctOptions, (Handler<AsyncResult<JsonArray>>)((Handler)ar -> {}));
    }

    public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.distinct(collection, fieldName, resultClassname, distinctOptions, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
        return this;
    }

    public MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return this.distinctWithQuery(collection, fieldName, resultClassname, query, (Handler<AsyncResult<JsonArray>>)((Handler)ar -> {}));
    }

    public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.distinctWithQuery(collection, fieldName, resultClassname, query, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, resultHandler);
        return this;
    }

    public MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        return this.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, (Handler<AsyncResult<JsonArray>>)((Handler)ar -> {}));
    }

    public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection, fieldName, resultClassname), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection, fieldName, resultClassname, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregate(collection, pipeline), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregateWithOptions(collection, pipeline, options), TypeArg.unknown());
        return ret;
    }

    public MongoClient createDefaultGridFsBucketService(Handler<AsyncResult<MongoGridFsClient>> resultHandler) {
        this.delegate.createDefaultGridFsBucketService(Helper.convertHandler(resultHandler, ar -> ar.map(event -> MongoGridFsClient.newInstance(event))));
        return this;
    }

    public MongoClient createDefaultGridFsBucketService() {
        return this.createDefaultGridFsBucketService((Handler<AsyncResult<MongoGridFsClient>>)((Handler)ar -> {}));
    }

    public Single<MongoGridFsClient> rxCreateDefaultGridFsBucketService() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createDefaultGridFsBucketService((Handler<AsyncResult<MongoGridFsClient>>)fut)));
    }

    public MongoClient createGridFsBucketService(String bucketName, Handler<AsyncResult<MongoGridFsClient>> resultHandler) {
        this.delegate.createGridFsBucketService(bucketName, Helper.convertHandler(resultHandler, ar -> ar.map(event -> MongoGridFsClient.newInstance(event))));
        return this;
    }

    public MongoClient createGridFsBucketService(String bucketName) {
        return this.createGridFsBucketService(bucketName, (Handler<AsyncResult<MongoGridFsClient>>)((Handler)ar -> {}));
    }

    public Single<MongoGridFsClient> rxCreateGridFsBucketService(String bucketName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createGridFsBucketService(bucketName, (Handler<AsyncResult<MongoGridFsClient>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public ReadStream<ChangeStreamDocument<JsonObject>> watch(String collection, JsonArray pipeline, boolean withUpdatedDoc, int batchSize) {
        ReadStream<ChangeStreamDocument<JsonObject>> ret = ReadStream.newInstance(this.delegate.watch(collection, pipeline, withUpdatedDoc, batchSize), TypeArg.unknown());
        return ret;
    }

    public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
        return arg != null ? new MongoClient(arg) : null;
    }
}

