/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.kafka.client.consumer;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import io.vertx.kafka.client.consumer.OffsetAndTimestamp;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord;
import io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecords;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;

@RxGen(value=io.vertx.kafka.client.consumer.KafkaConsumer.class)
public class KafkaConsumer<K, V>
implements RxDelegate,
ReadStream<KafkaConsumerRecord<K, V>> {
    public static final TypeArg<KafkaConsumer> __TYPE_ARG = new TypeArg(obj -> new KafkaConsumer((io.vertx.kafka.client.consumer.KafkaConsumer)obj), KafkaConsumer::getDelegate);
    private final io.vertx.kafka.client.consumer.KafkaConsumer<K, V> delegate;
    public final TypeArg<K> __typeArg_0;
    public final TypeArg<V> __typeArg_1;
    private Observable<KafkaConsumerRecord<K, V>> observable;
    private Flowable<KafkaConsumerRecord<K, V>> flowable;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaConsumer that = (KafkaConsumer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
        this.__typeArg_1 = TypeArg.unknown();
    }

    public KafkaConsumer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
        this.delegate = (io.vertx.kafka.client.consumer.KafkaConsumer)delegate;
        this.__typeArg_0 = typeArg_0;
        this.__typeArg_1 = typeArg_1;
    }

    public io.vertx.kafka.client.consumer.KafkaConsumer getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<KafkaConsumerRecord<K, V>> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord, KafkaConsumerRecord> conv = KafkaConsumerRecord::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<KafkaConsumerRecord<K, V>> toFlowable() {
        if (this.flowable == null) {
            Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord, KafkaConsumerRecord> conv = KafkaConsumerRecord::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public Pipe<KafkaConsumerRecord<K, V>> pipe() {
        Pipe<KafkaConsumerRecord<K, V>> ret = Pipe.newInstance(this.delegate.pipe(), new TypeArg(o0 -> KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)o0, this.__typeArg_0, this.__typeArg_1), o0 -> o0.getDelegate()));
        return ret;
    }

    @Override
    public Future<Void> pipeTo(WriteStream<KafkaConsumerRecord<K, V>> dst) {
        Future ret = this.delegate.pipeTo(dst.getDelegate()).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<KafkaConsumerRecord<K, V>> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst).onComplete($handler));
    }

    public static <K, V> KafkaConsumer<K, V> create(io.vertx.reactivex.core.Vertx vertx, Map<String, String> config) {
        KafkaConsumer<K, V> ret = KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create((Vertx)vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
        return ret;
    }

    public static <K, V> KafkaConsumer<K, V> create(io.vertx.reactivex.core.Vertx vertx, Map<String, String> config, Class<K> keyType, Class<V> valueType) {
        KafkaConsumer<K, V> ret = KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create((Vertx)vertx.getDelegate(), config, (Class)Helper.unwrap(keyType), (Class)Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
        return ret;
    }

    public static <K, V> KafkaConsumer<K, V> create(io.vertx.reactivex.core.Vertx vertx, KafkaClientOptions options) {
        KafkaConsumer<K, V> ret = KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create((Vertx)vertx.getDelegate(), (KafkaClientOptions)options), TypeArg.unknown(), TypeArg.unknown());
        return ret;
    }

    public static <K, V> KafkaConsumer<K, V> create(io.vertx.reactivex.core.Vertx vertx, KafkaClientOptions options, Class<K> keyType, Class<V> valueType) {
        KafkaConsumer<K, V> ret = KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create((Vertx)vertx.getDelegate(), (KafkaClientOptions)options, (Class)Helper.unwrap(keyType), (Class)Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
        return ret;
    }

    @Override
    public KafkaConsumer<K, V> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public KafkaConsumer<K, V> handler(Handler<KafkaConsumerRecord<K, V>> handler) {
        this.delegate.handler(Helper.convertHandler(handler, event -> KafkaConsumerRecord.newInstance(event, this.__typeArg_0, this.__typeArg_1)));
        return this;
    }

    public KafkaConsumer<K, V> pause() {
        this.delegate.pause();
        return this;
    }

    public KafkaConsumer<K, V> resume() {
        this.delegate.resume();
        return this;
    }

    public KafkaConsumer<K, V> fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public KafkaConsumer<K, V> endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public long demand() {
        long ret = this.delegate.demand();
        return ret;
    }

    public Future<Void> subscribe(String topic) {
        Future ret = this.delegate.subscribe(topic).map(val -> val);
        return ret;
    }

    public Completable rxSubscribe(String topic) {
        return AsyncResultCompletable.toCompletable($handler -> this.subscribe(topic).onComplete($handler));
    }

    public Future<Void> subscribe(Set<String> topics) {
        Future ret = this.delegate.subscribe(topics).map(val -> val);
        return ret;
    }

    public Completable rxSubscribe(Set<String> topics) {
        return AsyncResultCompletable.toCompletable($handler -> this.subscribe(topics).onComplete($handler));
    }

    public Future<Void> assign(TopicPartition topicPartition) {
        Future ret = this.delegate.assign(topicPartition).map(val -> val);
        return ret;
    }

    public Completable rxAssign(TopicPartition topicPartition) {
        return AsyncResultCompletable.toCompletable($handler -> this.assign(topicPartition).onComplete($handler));
    }

    public Future<Void> assign(Set<TopicPartition> topicPartitions) {
        Future ret = this.delegate.assign(topicPartitions).map(val -> val);
        return ret;
    }

    public Completable rxAssign(Set<TopicPartition> topicPartitions) {
        return AsyncResultCompletable.toCompletable($handler -> this.assign(topicPartitions).onComplete($handler));
    }

    public Future<Set<TopicPartition>> assignment() {
        Future ret = this.delegate.assignment().map(val -> val);
        return ret;
    }

    public Single<Set<TopicPartition>> rxAssignment() {
        return AsyncResultSingle.toSingle($handler -> this.assignment().onComplete($handler));
    }

    public Future<Void> unsubscribe() {
        Future ret = this.delegate.unsubscribe().map(val -> val);
        return ret;
    }

    public Completable rxUnsubscribe() {
        return AsyncResultCompletable.toCompletable($handler -> this.unsubscribe().onComplete($handler));
    }

    public Future<Set<String>> subscription() {
        Future ret = this.delegate.subscription().map(val -> val);
        return ret;
    }

    public Single<Set<String>> rxSubscription() {
        return AsyncResultSingle.toSingle($handler -> this.subscription().onComplete($handler));
    }

    public Future<Void> pause(TopicPartition topicPartition) {
        Future ret = this.delegate.pause(topicPartition).map(val -> val);
        return ret;
    }

    public Completable rxPause(TopicPartition topicPartition) {
        return AsyncResultCompletable.toCompletable($handler -> this.pause(topicPartition).onComplete($handler));
    }

    public Future<Void> pause(Set<TopicPartition> topicPartitions) {
        Future ret = this.delegate.pause(topicPartitions).map(val -> val);
        return ret;
    }

    public Completable rxPause(Set<TopicPartition> topicPartitions) {
        return AsyncResultCompletable.toCompletable($handler -> this.pause(topicPartitions).onComplete($handler));
    }

    public Future<Set<TopicPartition>> paused() {
        Future ret = this.delegate.paused().map(val -> val);
        return ret;
    }

    public Single<Set<TopicPartition>> rxPaused() {
        return AsyncResultSingle.toSingle($handler -> this.paused().onComplete($handler));
    }

    public Future<Void> resume(TopicPartition topicPartition) {
        Future ret = this.delegate.resume(topicPartition).map(val -> val);
        return ret;
    }

    public Completable rxResume(TopicPartition topicPartition) {
        return AsyncResultCompletable.toCompletable($handler -> this.resume(topicPartition).onComplete($handler));
    }

    public Future<Void> resume(Set<TopicPartition> topicPartitions) {
        Future ret = this.delegate.resume(topicPartitions).map(val -> val);
        return ret;
    }

    public Completable rxResume(Set<TopicPartition> topicPartitions) {
        return AsyncResultCompletable.toCompletable($handler -> this.resume(topicPartitions).onComplete($handler));
    }

    public KafkaConsumer<K, V> partitionsRevokedHandler(Handler<Set<TopicPartition>> handler) {
        this.delegate.partitionsRevokedHandler(handler);
        return this;
    }

    public KafkaConsumer<K, V> partitionsAssignedHandler(Handler<Set<TopicPartition>> handler) {
        this.delegate.partitionsAssignedHandler(handler);
        return this;
    }

    public Future<Void> seek(TopicPartition topicPartition, long offset) {
        Future ret = this.delegate.seek(topicPartition, offset).map(val -> val);
        return ret;
    }

    public Completable rxSeek(TopicPartition topicPartition, long offset) {
        return AsyncResultCompletable.toCompletable($handler -> this.seek(topicPartition, offset).onComplete($handler));
    }

    public Future<Void> seek(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        Future ret = this.delegate.seek(topicPartition, offsetAndMetadata).map(val -> val);
        return ret;
    }

    public Completable rxSeek(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        return AsyncResultCompletable.toCompletable($handler -> this.seek(topicPartition, offsetAndMetadata).onComplete($handler));
    }

    public Future<Void> seekToBeginning(TopicPartition topicPartition) {
        Future ret = this.delegate.seekToBeginning(topicPartition).map(val -> val);
        return ret;
    }

    public Completable rxSeekToBeginning(TopicPartition topicPartition) {
        return AsyncResultCompletable.toCompletable($handler -> this.seekToBeginning(topicPartition).onComplete($handler));
    }

    public Future<Void> seekToBeginning(Set<TopicPartition> topicPartitions) {
        Future ret = this.delegate.seekToBeginning(topicPartitions).map(val -> val);
        return ret;
    }

    public Completable rxSeekToBeginning(Set<TopicPartition> topicPartitions) {
        return AsyncResultCompletable.toCompletable($handler -> this.seekToBeginning(topicPartitions).onComplete($handler));
    }

    public Future<Void> seekToEnd(TopicPartition topicPartition) {
        Future ret = this.delegate.seekToEnd(topicPartition).map(val -> val);
        return ret;
    }

    public Completable rxSeekToEnd(TopicPartition topicPartition) {
        return AsyncResultCompletable.toCompletable($handler -> this.seekToEnd(topicPartition).onComplete($handler));
    }

    public Future<Void> seekToEnd(Set<TopicPartition> topicPartitions) {
        Future ret = this.delegate.seekToEnd(topicPartitions).map(val -> val);
        return ret;
    }

    public Completable rxSeekToEnd(Set<TopicPartition> topicPartitions) {
        return AsyncResultCompletable.toCompletable($handler -> this.seekToEnd(topicPartitions).onComplete($handler));
    }

    public Future<Void> commit() {
        Future ret = this.delegate.commit().map(val -> val);
        return ret;
    }

    public Completable rxCommit() {
        return AsyncResultCompletable.toCompletable($handler -> this.commit().onComplete($handler));
    }

    public Future<OffsetAndMetadata> committed(TopicPartition topicPartition) {
        Future ret = this.delegate.committed(topicPartition).map(val -> val);
        return ret;
    }

    public Single<OffsetAndMetadata> rxCommitted(TopicPartition topicPartition) {
        return AsyncResultSingle.toSingle($handler -> this.committed(topicPartition).onComplete($handler));
    }

    public Future<List<PartitionInfo>> partitionsFor(String topic) {
        Future ret = this.delegate.partitionsFor(topic).map(val -> val);
        return ret;
    }

    public Single<List<PartitionInfo>> rxPartitionsFor(String topic) {
        return AsyncResultSingle.toSingle($handler -> this.partitionsFor(topic).onComplete($handler));
    }

    public KafkaConsumer<K, V> batchHandler(Handler<KafkaConsumerRecords<K, V>> handler) {
        this.delegate.batchHandler(Helper.convertHandler(handler, event -> KafkaConsumerRecords.newInstance(event, this.__typeArg_0, this.__typeArg_1)));
        return this;
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<Long> position(TopicPartition partition) {
        Future ret = this.delegate.position(partition).map(val -> val);
        return ret;
    }

    public Single<Long> rxPosition(TopicPartition partition) {
        return AsyncResultSingle.toSingle($handler -> this.position(partition).onComplete($handler));
    }

    public Future<OffsetAndTimestamp> offsetsForTimes(TopicPartition topicPartition, Long timestamp) {
        Future ret = this.delegate.offsetsForTimes(topicPartition, timestamp).map(val -> val);
        return ret;
    }

    public Single<OffsetAndTimestamp> rxOffsetsForTimes(TopicPartition topicPartition, Long timestamp) {
        return AsyncResultSingle.toSingle($handler -> this.offsetsForTimes(topicPartition, timestamp).onComplete($handler));
    }

    public Future<Long> beginningOffsets(TopicPartition topicPartition) {
        Future ret = this.delegate.beginningOffsets(topicPartition).map(val -> val);
        return ret;
    }

    public Single<Long> rxBeginningOffsets(TopicPartition topicPartition) {
        return AsyncResultSingle.toSingle($handler -> this.beginningOffsets(topicPartition).onComplete($handler));
    }

    public Future<Long> endOffsets(TopicPartition topicPartition) {
        Future ret = this.delegate.endOffsets(topicPartition).map(val -> val);
        return ret;
    }

    public Single<Long> rxEndOffsets(TopicPartition topicPartition) {
        return AsyncResultSingle.toSingle($handler -> this.endOffsets(topicPartition).onComplete($handler));
    }

    public static <K, V> KafkaConsumer<K, V> create(io.vertx.reactivex.core.Vertx vertx, Consumer<K, V> consumer) {
        KafkaConsumer<K, V> ret = KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create((Vertx)vertx.getDelegate(), consumer), TypeArg.unknown(), TypeArg.unknown());
        return ret;
    }

    public static <K, V> KafkaConsumer<K, V> create(io.vertx.reactivex.core.Vertx vertx, Consumer<K, V> consumer, KafkaClientOptions options) {
        KafkaConsumer<K, V> ret = KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create((Vertx)vertx.getDelegate(), consumer, (KafkaClientOptions)options), TypeArg.unknown(), TypeArg.unknown());
        return ret;
    }

    public Future<Void> subscribe(Pattern pattern) {
        Future ret = this.delegate.subscribe(pattern).map(val -> val);
        return ret;
    }

    public Completable rxSubscribe(Pattern pattern) {
        return AsyncResultCompletable.toCompletable($handler -> this.subscribe(pattern).onComplete($handler));
    }

    public KafkaConsumer<K, V> pollTimeout(Duration timeout) {
        this.delegate.pollTimeout(timeout);
        return this;
    }

    public Future<KafkaConsumerRecords<K, V>> poll(Duration timeout) {
        Future ret = this.delegate.poll(timeout).map(val -> KafkaConsumerRecords.newInstance(val, this.__typeArg_0, this.__typeArg_1));
        return ret;
    }

    public Single<KafkaConsumerRecords<K, V>> rxPoll(Duration timeout) {
        return AsyncResultSingle.toSingle($handler -> this.poll(timeout).onComplete($handler));
    }

    public static <K, V> KafkaConsumer<K, V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg) {
        return arg != null ? new KafkaConsumer<K, V>(arg) : null;
    }

    public static <K, V> KafkaConsumer<K, V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
        return arg != null ? new KafkaConsumer<K, V>(arg, __typeArg_K, __typeArg_V) : null;
    }
}

