/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.function.Function;

public abstract class ProxyHandler
implements Handler<Message<JsonObject>> {
    protected boolean closed;
    protected MessageConsumer<JsonObject> consumer;

    public void close() {
        this.consumer.unregister();
        this.closed = true;
    }

    public MessageConsumer<JsonObject> register(EventBus eventBus, String address) {
        return this.register(eventBus, address, null);
    }

    public MessageConsumer<JsonObject> registerLocal(EventBus eventBus, String address) {
        return this.registerLocal(eventBus, address, null);
    }

    public MessageConsumer<JsonObject> register(EventBus eventBus, String address, List<Function<Message<JsonObject>, Future<Message<JsonObject>>>> interceptors) {
        Handler<Message<JsonObject>> handler = this.configureHandler(interceptors);
        this.consumer = eventBus.consumer(address, handler);
        return this.consumer;
    }

    public MessageConsumer<JsonObject> registerLocal(EventBus eventBus, String address, List<Function<Message<JsonObject>, Future<Message<JsonObject>>>> interceptors) {
        Handler<Message<JsonObject>> handler = this.configureHandler(interceptors);
        this.consumer = eventBus.localConsumer(address, handler);
        return this.consumer;
    }

    private Handler<Message<JsonObject>> configureHandler(List<Function<Message<JsonObject>, Future<Message<JsonObject>>>> interceptors) {
        ProxyHandler handler = this;
        if (interceptors != null) {
            for (Function<Message<JsonObject>, Future<Message<JsonObject>>> interceptor : interceptors) {
                ProxyHandler prev = handler;
                handler = msg -> {
                    Future fut = (Future)interceptor.apply((Message<JsonObject>)msg);
                    fut.onComplete(ar -> {
                        if (ar.succeeded()) {
                            prev.handle(msg);
                        } else {
                            ReplyException exception = (ReplyException)ar.cause();
                            msg.fail(exception.failureCode(), exception.getMessage());
                        }
                    });
                };
            }
        }
        return handler;
    }
}

