/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ProxyUtils {
    public static List<Character> convertToListChar(JsonArray arr) {
        return arr.stream().map(ProxyUtils::javaObjToChar).collect(Collectors.toList());
    }

    public static Set<Character> convertToSetChar(JsonArray arr) {
        return arr.stream().map(ProxyUtils::javaObjToChar).collect(Collectors.toSet());
    }

    public static Map<String, Character> convertToMapChar(JsonObject obj) {
        return obj.stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ProxyUtils.javaObjToChar(e.getValue())));
    }

    public static Character javaObjToChar(Object obj) {
        Integer jobj = (Integer)obj;
        return Character.valueOf((char)jobj.intValue());
    }

    public static <T> Map<String, T> convertMap(Map map) {
        if (map.isEmpty()) {
            return map;
        }
        Object elem = map.values().stream().findFirst().get();
        if (!(elem instanceof Map) && !(elem instanceof List)) {
            return map;
        }
        Function<Object, Object> converter = elem instanceof List ? object -> new JsonArray((List)object) : object -> new JsonObject((Map)object);
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, converter::apply));
    }

    public static <T> List<T> convertList(List list) {
        if (list.isEmpty()) {
            return list;
        }
        Object elem = list.get(0);
        if (!(elem instanceof Map) && !(elem instanceof List)) {
            return list;
        }
        Function<Object, Object> converter = elem instanceof List ? object -> new JsonArray((List)object) : object -> new JsonObject((Map)object);
        return list.stream().map(converter).collect(Collectors.toList());
    }

    public static <T> Set<T> convertSet(List list) {
        return new HashSet<T>(ProxyUtils.convertList(list));
    }
}

