/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceresolver.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.endpoint.EndpointResolverInternal;
import io.vertx.core.net.Address;
import io.vertx.core.net.endpoint.Endpoint;
import io.vertx.serviceresolver.ServiceAddress;
import io.vertx.serviceresolver.ServiceResolverClient;

public class ServiceResolverClientImpl
implements ServiceResolverClient {
    private final VertxInternal vertx;
    private final EndpointResolverInternal resolver;
    private long timerId;
    private boolean closed;

    public ServiceResolverClientImpl(Vertx vertx, EndpointResolverInternal resolver) {
        this.vertx = (VertxInternal)vertx;
        this.resolver = resolver;
    }

    public void init() {
        this.checkExpired();
    }

    private synchronized void checkExpired() {
        if (this.closed) {
            return;
        }
        this.timerId = this.vertx.setTimer(1000L, id -> {
            ServiceResolverClientImpl serviceResolverClientImpl = this;
            synchronized (serviceResolverClientImpl) {
                this.timerId = -1L;
            }
            this.resolver.checkExpired();
            this.checkExpired();
        });
    }

    public Future<Endpoint> resolveEndpoint(Address address) {
        return this.resolver.resolveEndpoint(address);
    }

    @Override
    public Future<Endpoint> resolveEndpoint(ServiceAddress address) {
        return this.resolver.resolveEndpoint((Address)address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close() {
        long id;
        ServiceResolverClientImpl serviceResolverClientImpl = this;
        synchronized (serviceResolverClientImpl) {
            if (this.closed) {
                return this.vertx.getOrCreateContext().succeededFuture();
            }
            id = this.timerId;
            this.closed = true;
            this.timerId = -1L;
        }
        if (id >= 0L) {
            this.vertx.cancelTimer(id);
        }
        return this.vertx.getOrCreateContext().succeededFuture();
    }
}

