/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceresolver.kube.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.core.spi.endpoint.EndpointResolver;
import io.vertx.serviceresolver.ServiceAddress;
import io.vertx.serviceresolver.kube.KubeResolverOptions;
import io.vertx.serviceresolver.kube.impl.KubeServiceState;

public class KubeResolverImpl<B>
implements EndpointResolver<ServiceAddress, SocketAddress, KubeServiceState<B>, B> {
    final KubeResolverOptions options;
    final SocketAddress server;
    Vertx vertx;
    WebSocketClient wsClient;
    HttpClient httpClient;
    final String namespace;
    final String bearerToken;

    public KubeResolverImpl(Vertx vertx, KubeResolverOptions options) {
        HttpClientOptions httpClientOptions = options.getHttpClientOptions();
        WebSocketClientOptions wsClientOptions = options.getWebSocketClientOptions();
        this.vertx = vertx;
        this.wsClient = vertx.createWebSocketClient(wsClientOptions == null ? new WebSocketClientOptions() : wsClientOptions);
        this.httpClient = vertx.createHttpClient(httpClientOptions == null ? new HttpClientOptions() : httpClientOptions);
        this.options = options;
        this.namespace = options.getNamespace();
        this.server = options.getServer();
        this.bearerToken = options.getBearerToken();
    }

    public ServiceAddress tryCast(Address address) {
        return address instanceof ServiceAddress ? (ServiceAddress)address : null;
    }

    public Future<KubeServiceState<B>> resolve(ServiceAddress address, EndpointBuilder<B, SocketAddress> builder) {
        return this.httpClient.request(new RequestOptions().setMethod(HttpMethod.GET).setServer((Address)this.server).setURI("/api/v1/namespaces/" + this.namespace + "/endpoints")).compose(req -> {
            if (this.bearerToken != null) {
                req.putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("Bearer " + this.bearerToken));
            }
            return req.send().compose(resp -> {
                if (resp.statusCode() == 200) {
                    return resp.body().map(Buffer::toJsonObject);
                }
                return resp.body().transform(ar -> {
                    StringBuilder msg = new StringBuilder("Invalid status code " + resp.statusCode());
                    if (ar.succeeded()) {
                        msg.append(" : ").append(((Buffer)ar.result()).toString());
                    }
                    return Future.failedFuture((String)msg.toString());
                });
            });
        }).map(response -> {
            String resourceVersion = response.getJsonObject("metadata").getString("resourceVersion");
            KubeServiceState state = new KubeServiceState(builder, this, this.vertx, resourceVersion, address.name());
            JsonArray items = response.getJsonArray("items");
            for (int i = 0; i < items.size(); ++i) {
                JsonObject item = items.getJsonObject(i);
                state.handleEndpoints(item);
            }
            return state;
        }).andThen(ar -> {
            if (ar.succeeded()) {
                KubeServiceState res = (KubeServiceState)ar.result();
                res.connectWebSocket();
            }
        });
    }

    public B endpoint(KubeServiceState<B> data) {
        return data.endpoints.get();
    }

    public void close() {
    }

    public SocketAddress addressOf(SocketAddress endpoint) {
        return endpoint;
    }

    public void dispose(KubeServiceState<B> unused) {
        unused.disposed = true;
        if (unused.ws != null) {
            unused.ws.close();
        }
    }

    public boolean isValid(KubeServiceState<B> state) {
        return true;
    }
}

