/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceresolver.kube.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.serviceresolver.kube.impl.KubeResolverImpl;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;

class KubeServiceState<B> {
    final String name;
    final Vertx vertx;
    final KubeResolverImpl resolver;
    final EndpointBuilder<B, SocketAddress> endpointsBuilder;
    String lastResourceVersion;
    boolean disposed;
    WebSocket ws;
    AtomicReference<B> endpoints = new AtomicReference();

    KubeServiceState(EndpointBuilder<B, SocketAddress> endpointsBuilder, KubeResolverImpl resolver, Vertx vertx, String lastResourceVersion, String name) {
        this.endpointsBuilder = endpointsBuilder;
        this.name = name;
        this.resolver = resolver;
        this.vertx = vertx;
        this.lastResourceVersion = lastResourceVersion;
    }

    void connectWebSocket() {
        String requestURI = "/api/v1/namespaces/" + this.resolver.namespace + "/endpoints?watch=true&allowWatchBookmarks=true&resourceVersion=" + this.lastResourceVersion;
        WebSocketConnectOptions connectOptions = new WebSocketConnectOptions();
        connectOptions.setServer((Address)this.resolver.server);
        connectOptions.setURI(requestURI);
        if (this.resolver.bearerToken != null) {
            connectOptions.putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("Bearer " + this.resolver.bearerToken));
        }
        this.resolver.wsClient.webSocket().handler(buff -> {
            JsonObject update = buff.toJsonObject();
            this.handleUpdate(update);
        }).closeHandler(v -> {
            if (!this.disposed) {
                this.connectWebSocket();
            }
        }).connect(connectOptions).onComplete(ar -> {
            if (ar.succeeded()) {
                WebSocket ws = (WebSocket)ar.result();
                if (this.disposed) {
                    ws.close();
                } else {
                    this.ws = ws;
                }
            } else if (!this.disposed) {
                this.vertx.setTimer(500L, id -> this.connectWebSocket());
            }
        });
    }

    void handleUpdate(JsonObject update) {
        String type = update.getString("type");
        JsonObject object = update.getJsonObject("object");
        JsonObject metadata = object.getJsonObject("metadata");
        String resourceVersion = metadata.getString("resourceVersion");
        if (!this.lastResourceVersion.equals(resourceVersion)) {
            this.handleEndpoints(object);
        }
    }

    void handleEndpoints(JsonObject item) {
        JsonObject metadata = item.getJsonObject("metadata");
        String name = metadata.getString("name");
        if (this.name.equals(name)) {
            JsonArray subsets = item.getJsonArray("subsets");
            EndpointBuilder builder = this.endpointsBuilder;
            if (subsets != null) {
                for (int j = 0; j < subsets.size(); ++j) {
                    int k;
                    ArrayList<String> podIps = new ArrayList<String>();
                    JsonObject subset = subsets.getJsonObject(j);
                    JsonArray addresses = subset.getJsonArray("addresses");
                    JsonArray ports = subset.getJsonArray("ports");
                    for (k = 0; k < addresses.size(); ++k) {
                        JsonObject address = addresses.getJsonObject(k);
                        String ip = address.getString("ip");
                        podIps.add(ip);
                    }
                    for (k = 0; k < ports.size(); ++k) {
                        JsonObject port = ports.getJsonObject(k);
                        int podPort = port.getInteger("port");
                        for (String podIp : podIps) {
                            SocketAddress podAddress = SocketAddress.inetSocketAddress((int)podPort, (String)podIp);
                            builder = builder.addServer((Object)podAddress, podIp + "-" + podPort);
                        }
                    }
                }
            }
            this.endpoints.set(builder.build());
        }
    }
}

