/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceresolver.srv;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SocketAddress;
import io.vertx.serviceresolver.ServiceResolverOptions;
import io.vertx.serviceresolver.srv.SrvResolverOptionsConverter;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public class SrvResolverOptions
extends ServiceResolverOptions {
    public static final SocketAddress DEFAULT_SERVER = SocketAddress.inetSocketAddress((int)53, (String)"127.0.0.1");
    public static final int MIN_TTL = 0;
    public static final TimeUnit MIN_TTL_UNIT = TimeUnit.SECONDS;
    private SocketAddress server = DEFAULT_SERVER;
    private int minTTL = 0;
    private TimeUnit minTTLUnit = TimeUnit.SECONDS;

    public SrvResolverOptions() {
    }

    public SrvResolverOptions(SrvResolverOptions other) {
        this.server = other.server;
        this.minTTL = other.minTTL;
        this.minTTLUnit = other.minTTLUnit;
    }

    public SrvResolverOptions(JsonObject json) {
        SrvResolverOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public SocketAddress getServer() {
        return this.server;
    }

    public SrvResolverOptions setServer(SocketAddress server) {
        this.server = server;
        return this;
    }

    public int getMinTTL() {
        return this.minTTL;
    }

    public SrvResolverOptions setMinTTL(int minTTL) {
        if (minTTL < 0) {
            throw new IllegalArgumentException("Min TTL (" + minTTL + ") must be > 0");
        }
        this.minTTL = minTTL;
        return this;
    }

    public TimeUnit getMinTTLUnit() {
        return this.minTTLUnit;
    }

    public SrvResolverOptions setMinTTLUnit(TimeUnit minTTLUnit) {
        this.minTTLUnit = minTTLUnit;
        return this;
    }
}

