/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceresolver.srv.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.core.spi.endpoint.EndpointResolver;
import io.vertx.serviceresolver.ServiceAddress;
import io.vertx.serviceresolver.srv.SrvResolverOptions;
import io.vertx.serviceresolver.srv.impl.SrvServiceState;

public class SrvResolverImpl<B>
implements EndpointResolver<ServiceAddress, SrvRecord, SrvServiceState<B>, B> {
    Vertx vertx;
    DnsClient client;
    final SocketAddress server;
    final int minTTL;

    public SrvResolverImpl(Vertx vertx, SrvResolverOptions options) {
        this.server = options.getServer();
        this.vertx = vertx;
        this.client = vertx.createDnsClient(this.server.port(), this.server.host());
        this.minTTL = options.getMinTTL();
    }

    public ServiceAddress tryCast(Address address) {
        return address instanceof ServiceAddress ? (ServiceAddress)address : null;
    }

    public Future<SrvServiceState<B>> resolve(ServiceAddress address, EndpointBuilder<B, SrvRecord> builder) {
        SrvServiceState<B> state = new SrvServiceState<B>(this, builder, address);
        return state.refresh().map(state);
    }

    public B endpoint(SrvServiceState<B> data) {
        return data.endpoints();
    }

    public SocketAddress addressOf(SrvRecord record) {
        return SocketAddress.inetSocketAddress((int)record.port(), (String)record.target());
    }

    public void dispose(SrvServiceState state) {
        state.dispose();
    }

    public boolean isValid(SrvServiceState state) {
        return state.isValid();
    }

    public void close() {
    }
}

