/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceresolver.srv.impl;

import io.vertx.core.Future;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.serviceresolver.ServiceAddress;
import io.vertx.serviceresolver.srv.impl.SrvResolverImpl;
import java.util.List;

class SrvServiceState<B> {
    final ServiceAddress address;
    final SrvResolverImpl<B> resolver;
    final EndpointBuilder<B, SrvRecord> builder;
    private B endpoints;
    private long timerID;
    private boolean disposed;
    private boolean valid;

    public SrvServiceState(SrvResolverImpl<B> resolve, EndpointBuilder<B, SrvRecord> builder, ServiceAddress address) {
        this.resolver = resolve;
        this.address = address;
        this.builder = builder;
        this.timerID = -1L;
        this.valid = true;
    }

    synchronized B endpoints() {
        return this.endpoints;
    }

    synchronized boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<?> refresh() {
        SrvServiceState srvServiceState = this;
        synchronized (srvServiceState) {
            if (this.disposed || this.timerID >= 0L) {
                return null;
            }
            Future fut = this.resolver.client.resolveSRV(this.address.name());
            return fut.andThen(ar -> {
                if (ar.succeeded()) {
                    List records = (List)ar.result();
                    long ttl = Long.MAX_VALUE;
                    EndpointBuilder tmp = this.builder;
                    for (SrvRecord record : records) {
                        tmp = tmp.addServer((Object)record, record.target() + "-" + record.port());
                        ttl = Math.min(ttl, record.ttl());
                    }
                    SrvServiceState srvServiceState = this;
                    synchronized (srvServiceState) {
                        this.endpoints = tmp.build();
                    }
                    ttl = Math.max(ttl, (long)this.resolver.minTTL);
                    if (ttl > 0L) {
                        this.timerID = this.resolver.vertx.setTimer(ttl * 1000L, id -> {
                            SrvServiceState srvServiceState = this;
                            synchronized (srvServiceState) {
                                this.timerID = -1L;
                            }
                            this.refresh();
                        });
                    } else {
                        this.valid = false;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        long id;
        SrvServiceState srvServiceState = this;
        synchronized (srvServiceState) {
            id = this.timerID;
            this.timerID = -1L;
            this.disposed = true;
        }
        if (id >= 0L) {
            this.resolver.vertx.cancelTimer(id);
        }
    }
}

