/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.CursorImpl;
import io.vertx.sqlclient.impl.QueryBase;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.RowStreamImpl;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.SqlResultHandler;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collector;

class PreparedStatementImpl
implements PreparedStatement {
    final Connection conn;
    final Context context;
    final io.vertx.sqlclient.impl.PreparedStatement ps;
    final boolean autoCommit;
    private final AtomicBoolean closed = new AtomicBoolean();

    PreparedStatementImpl(Connection conn, Context context, io.vertx.sqlclient.impl.PreparedStatement ps, boolean autoCommit) {
        this.conn = conn;
        this.context = context;
        this.ps = ps;
        this.autoCommit = autoCommit;
    }

    @Override
    public PreparedQuery<RowSet<Row>> query() {
        SqlResultBuilder builder = new SqlResultBuilder(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
        return new PreparedStatementQuery(builder);
    }

    <R1, R2 extends SqlResultBase<R1, R2>, R3 extends SqlResult<R1>> void execute(TupleInternal args, int fetch, String cursorId, boolean suspended, SqlResultBuilder<R1, R2, R3> resultBuilder, Handler<AsyncResult<R3>> handler) {
        if (this.context == Vertx.currentContext()) {
            String msg = this.ps.prepare(args);
            if (msg != null) {
                handler.handle((Object)Future.failedFuture((String)msg));
            } else {
                SqlResultHandler<R1, R2, R3> resultHandler = resultBuilder.createHandler(handler);
                this.conn.schedule(resultBuilder.createExtendedQuery(this.ps, args, fetch, cursorId, suspended, this.autoCommit, resultHandler), resultHandler);
            }
        } else {
            this.context.runOnContext(v -> this.execute(args, fetch, cursorId, suspended, resultBuilder, handler));
        }
    }

    @Override
    public Cursor cursor(Tuple args) {
        return this.cursor((TupleInternal)args);
    }

    private Cursor cursor(TupleInternal args) {
        String msg = this.ps.prepare(args);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        return new CursorImpl(this, args);
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    private <R1, R2 extends SqlResultBase<R1, R2>, R3 extends SqlResult<R1>> void batch(List<Tuple> argsList, SqlResultBuilder<R1, R2, R3> builder, Handler<AsyncResult<R3>> handler) {
        for (Tuple args : argsList) {
            String msg = this.ps.prepare((TupleInternal)args);
            if (msg == null) continue;
            handler.handle((Object)Future.failedFuture((String)msg));
            return;
        }
        SqlResultHandler<R1, R2, R3> resultHandler = builder.createHandler(handler);
        this.conn.schedule(builder.createBatchCommand(this.ps, argsList, this.autoCommit, resultHandler), resultHandler);
    }

    @Override
    public RowStream<Row> createStream(int fetch, Tuple args) {
        return new RowStreamImpl(this, fetch, args);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed.compareAndSet(false, true)) {
            CloseStatementCommand cmd = new CloseStatementCommand(this.ps);
            cmd.handler = completionHandler;
            this.conn.schedule(cmd);
        } else {
            completionHandler.handle((Object)Future.failedFuture((String)"Already closed"));
        }
    }

    void closeCursor(String cursorId, Handler<AsyncResult<Void>> handler) {
        CloseCursorCommand cmd = new CloseCursorCommand(cursorId, this.ps);
        cmd.handler = handler;
        this.conn.schedule(cmd);
    }

    private class PreparedStatementQuery<T, R extends SqlResult<T>>
    extends QueryBase<T, R>
    implements PreparedQuery<R> {
        public PreparedStatementQuery(SqlResultBuilder<T, ?, R> builder) {
            super(builder);
        }

        @Override
        protected <T2, R2 extends SqlResult<T2>> QueryBase<T2, R2> copy(SqlResultBuilder<T2, ?, R2> builder) {
            return new PreparedStatementQuery<T2, R2>(builder);
        }

        @Override
        public <U> PreparedQuery<SqlResult<U>> collecting(Collector<Row, ?, U> collector) {
            return (PreparedQuery)super.collecting(collector);
        }

        @Override
        public <U> PreparedQuery<RowSet<U>> mapping(Function<Row, U> mapper) {
            return (PreparedQuery)super.mapping(mapper);
        }

        @Override
        public void execute(Handler<AsyncResult<R>> handler) {
            this.execute(ArrayTuple.EMPTY, handler);
        }

        @Override
        public void execute(Tuple args, Handler<AsyncResult<R>> handler) {
            PreparedStatementImpl.this.execute((TupleInternal)args, 0, null, false, this.builder, handler);
        }

        @Override
        public void executeBatch(List<Tuple> argsList, Handler<AsyncResult<R>> handler) {
            PreparedStatementImpl.this.batch(argsList, this.builder, handler);
        }
    }
}

