/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatementImpl;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;

public abstract class SqlConnectionBase<C extends SqlConnectionBase>
extends SqlClientBase<C> {
    protected final Context context;
    protected final Connection conn;

    protected SqlConnectionBase(Context context, Connection conn) {
        this.context = context;
        this.conn = conn;
    }

    public C prepare(String sql, Handler<AsyncResult<PreparedStatement>> handler) {
        this.schedule(new PrepareStatementCommand(sql, false), cr -> {
            if (cr.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)new PreparedStatementImpl(this.conn, this.context, (io.vertx.sqlclient.impl.PreparedStatement)cr.result(), this.autoCommit())));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)cr.cause()));
            }
        });
        return (C)this;
    }
}

