/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.SqlResultBase;
import java.util.HashMap;
import java.util.function.Function;

class SqlResultHandler<T, R extends SqlResultBase<T, R>, L extends SqlResult<T>>
implements QueryResultHandler<T>,
Handler<AsyncResult<Boolean>> {
    private final Handler<AsyncResult<L>> handler;
    private final Function<T, R> factory;
    private R first;
    private R current;
    private Throwable failure;
    private boolean suspended;

    SqlResultHandler(Function<T, R> factory, Handler<AsyncResult<L>> handler) {
        this.factory = factory;
        this.handler = handler;
    }

    @Override
    public void handleResult(int updatedCount, int size, RowDesc desc, T result, Throwable failure) {
        if (failure != null) {
            this.failure = failure;
        } else {
            SqlResultBase r = (SqlResultBase)this.factory.apply(result);
            r.updated = updatedCount;
            r.size = size;
            r.columnNames = desc != null ? desc.columnNames() : null;
            this.handleResult(r);
        }
    }

    private void handleResult(R result) {
        R c = this.current;
        if (c == null) {
            this.first = result;
            this.current = result;
        } else {
            ((SqlResultBase)c).next = result;
            this.current = result;
        }
    }

    @Override
    public <V> void addProperty(PropertyKind<V> property, V value) {
        R r = this.current;
        if (r != null) {
            if (((SqlResultBase)r).properties == null) {
                ((SqlResultBase)r).properties = new HashMap();
            }
            ((SqlResultBase)r).properties.put(property, value);
        }
    }

    public void handle(AsyncResult<Boolean> ar) {
        if (ar.succeeded()) {
            this.complete((Boolean)ar.result());
        } else if (ar.failed()) {
            this.fail(ar.cause());
        }
    }

    void complete(Boolean result) {
        this.suspended = result;
        if (this.failure != null) {
            this.handler.handle((Object)Future.failedFuture((Throwable)this.failure));
        } else {
            this.handler.handle((Object)Future.succeededFuture(this.first));
        }
    }

    void fail(Throwable cause) {
        this.handler.handle((Object)Future.failedFuture((Throwable)cause));
    }

    public boolean isSuspended() {
        return this.suspended;
    }
}

