/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.cache;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.sqlclient.impl.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.Map;

class LruCache
extends LinkedHashMap<String, AsyncResult<PreparedStatement>> {
    private final int capacity;
    private final Handler<AsyncResult<PreparedStatement>> onEvictedHandler;

    LruCache(int capacity, Handler<AsyncResult<PreparedStatement>> onEvictedHandler) {
        super(capacity, 0.75f, true);
        this.capacity = capacity;
        this.onEvictedHandler = onEvictedHandler;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, AsyncResult<PreparedStatement>> eldest) {
        boolean evict;
        boolean bl = evict = this.size() > this.capacity;
        if (evict) {
            this.onEvictedHandler.handle(eldest.getValue());
            return true;
        }
        return false;
    }
}

