/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class ConnectionPool {
    private final Consumer<Handler<AsyncResult<Connection>>> connector;
    private final int maxSize;
    private final ArrayDeque<Promise<Connection>> waiters = new ArrayDeque();
    private final Set<PooledConnection> all = new HashSet<PooledConnection>();
    private final ArrayDeque<PooledConnection> available = new ArrayDeque();
    private int size;
    private final int maxWaitQueueSize;
    private boolean checkInProgress;
    private boolean closed;

    public ConnectionPool(Consumer<Handler<AsyncResult<Connection>>> connector) {
        this(connector, 4, -1);
    }

    public ConnectionPool(Consumer<Handler<AsyncResult<Connection>>> connector, int maxSize) {
        this(connector, maxSize, -1);
    }

    public ConnectionPool(Consumer<Handler<AsyncResult<Connection>>> connector, int maxSize, int maxWaitQueueSize) {
        this.maxSize = maxSize;
        this.maxWaitQueueSize = maxWaitQueueSize;
        this.connector = connector;
    }

    public int available() {
        return this.available.size();
    }

    public int size() {
        return this.size;
    }

    public void acquire(Handler<AsyncResult<Connection>> holder) {
        if (this.closed) {
            throw new IllegalStateException("Connection pool closed");
        }
        Promise promise = Promise.promise();
        promise.future().setHandler(holder);
        this.waiters.add((Promise<Connection>)promise);
        this.check();
    }

    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Connection pool already closed");
        }
        this.closed = true;
        for (PooledConnection pooled : new ArrayList<PooledConnection>(this.all)) {
            pooled.close();
        }
        Future failure = Future.failedFuture((String)"Connection pool closed");
        for (Promise<Connection> pending : this.waiters) {
            try {
                pending.handle((AsyncResult)failure);
            }
            catch (Exception exception) {}
        }
    }

    private void release(PooledConnection proxy) {
        if (this.all.contains(proxy)) {
            this.available.add(proxy);
            this.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        if (this.closed) {
            return;
        }
        if (!this.checkInProgress) {
            this.checkInProgress = true;
            try {
                while (this.waiters.size() > 0) {
                    if (this.available.size() > 0) {
                        PooledConnection proxy = this.available.poll();
                        Promise<Connection> waiter = this.waiters.poll();
                        waiter.complete((Object)proxy);
                        continue;
                    }
                    if (this.size < this.maxSize) {
                        Promise<Connection> waiter = this.waiters.poll();
                        ++this.size;
                        this.connector.accept((Handler<AsyncResult<Connection>>)((Handler)ar -> {
                            if (ar.succeeded()) {
                                Connection conn = (Connection)ar.result();
                                PooledConnection proxy = new PooledConnection(conn);
                                this.all.add(proxy);
                                conn.init(proxy);
                                waiter.complete((Object)proxy);
                            } else {
                                --this.size;
                                waiter.fail(ar.cause());
                                this.check();
                            }
                        }));
                        continue;
                    }
                    if (this.maxWaitQueueSize >= 0) {
                        int numInProgress = this.size - this.all.size();
                        int numToFail = this.waiters.size() - (this.maxWaitQueueSize + numInProgress);
                        while (numToFail-- > 0) {
                            Promise<Connection> waiter = this.waiters.pollLast();
                            waiter.fail((Throwable)new NoStackTraceThrowable("Max waiter size reached"));
                        }
                    }
                    break;
                }
            }
            finally {
                this.checkInProgress = false;
            }
        }
    }

    private class PooledConnection
    implements Connection,
    Connection.Holder {
        private final Connection conn;
        private Connection.Holder holder;

        PooledConnection(Connection conn) {
            this.conn = conn;
        }

        @Override
        public boolean isSsl() {
            return this.conn.isSsl();
        }

        @Override
        public DatabaseMetadata getDatabaseMetaData() {
            return this.conn.getDatabaseMetaData();
        }

        @Override
        public void schedule(CommandBase<?> cmd) {
            this.conn.schedule(cmd);
        }

        private void close() {
            this.conn.close(this);
        }

        @Override
        public void init(Connection.Holder holder) {
            if (this.holder != null) {
                throw new IllegalStateException();
            }
            this.holder = holder;
        }

        @Override
        public void close(Connection.Holder holder) {
            if (holder != this.holder) {
                throw new IllegalStateException();
            }
            this.holder = null;
            ConnectionPool.this.release(this);
        }

        @Override
        public void handleClosed() {
            if (ConnectionPool.this.all.remove(this)) {
                ConnectionPool.this.size--;
                if (this.holder == null) {
                    ConnectionPool.this.available.remove(this);
                } else {
                    this.holder.handleClosed();
                }
            } else {
                throw new IllegalStateException();
            }
            ConnectionPool.this.check();
        }

        @Override
        public void handleNotification(int processId, String channel, String payload) {
            if (this.holder != null) {
                this.holder.handleNotification(processId, channel, payload);
            }
        }

        @Override
        public void handleException(Throwable err) {
            if (this.holder != null) {
                this.holder.handleException(err);
            }
        }

        @Override
        public int getProcessId() {
            return this.conn.getProcessId();
        }

        @Override
        public int getSecretKey() {
            return this.conn.getSecretKey();
        }
    }
}

