/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.QueryBase;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.SqlResultHandler;
import io.vertx.sqlclient.impl.command.CommandScheduler;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class SqlClientBase<C extends SqlClient>
implements SqlClient,
CommandScheduler {
    @Override
    public Query<RowSet<Row>> query(String sql) {
        SqlResultBuilder builder = new SqlResultBuilder(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
        return new QueryImpl(false, sql, builder);
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        SqlResultBuilder builder = new SqlResultBuilder(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
        return new PreparedQueryImpl(false, sql, builder);
    }

    boolean autoCommit() {
        return true;
    }

    private class PreparedQueryImpl<T, R extends SqlResult<T>>
    extends QueryImpl<T, R>
    implements PreparedQuery<R> {
        private PreparedQueryImpl(boolean singleton, String sql, SqlResultBuilder<T, ?, R> builder) {
            super(singleton, sql, builder);
        }

        @Override
        public <U> PreparedQuery<SqlResult<U>> collecting(Collector<Row, ?, U> collector) {
            return (PreparedQuery)super.collecting(collector);
        }

        @Override
        public void execute(Handler<AsyncResult<R>> handler) {
            this.execute(ArrayTuple.EMPTY, handler);
        }

        @Override
        public <U> PreparedQuery<RowSet<U>> mapping(Function<Row, U> mapper) {
            return (PreparedQuery)super.mapping(mapper);
        }

        @Override
        protected <T2, R2 extends SqlResult<T2>> QueryBase<T2, R2> copy(SqlResultBuilder<T2, ?, R2> builder) {
            return new PreparedQueryImpl<T2, R2>(this.singleton, this.sql, builder);
        }

        @Override
        public void execute(Tuple arguments, Handler<AsyncResult<R>> handler) {
            SqlResultHandler resultHandler = this.builder.createHandler(handler);
            ExtendedQueryCommand cmd = this.builder.createExtendedQuery(this.sql, arguments, SqlClientBase.this.autoCommit(), resultHandler);
            SqlClientBase.this.schedule(cmd, resultHandler);
        }

        @Override
        public void executeBatch(List<Tuple> batch, Handler<AsyncResult<R>> handler) {
            SqlResultHandler resultHandler = this.builder.createHandler(handler);
            ExtendedQueryCommand cmd = this.builder.createBatchCommand(this.sql, batch, SqlClientBase.this.autoCommit(), resultHandler);
            SqlClientBase.this.schedule(cmd, resultHandler);
        }
    }

    private class QueryImpl<T, R extends SqlResult<T>>
    extends QueryBase<T, R> {
        protected final boolean singleton;
        protected final String sql;

        private QueryImpl(boolean singleton, String sql, SqlResultBuilder<T, ?, R> builder) {
            super(builder);
            this.singleton = singleton;
            this.sql = sql;
        }

        @Override
        protected <T2, R2 extends SqlResult<T2>> QueryBase<T2, R2> copy(SqlResultBuilder<T2, ?, R2> builder) {
            return new QueryImpl<T2, R2>(this.singleton, this.sql, builder);
        }

        @Override
        public void execute(Handler<AsyncResult<R>> handler) {
            SqlResultHandler resultHandler = this.builder.createHandler(handler);
            SqlClientBase.this.schedule(this.builder.createSimpleQuery(this.sql, this.singleton, SqlClientBase.this.autoCommit(), resultHandler), resultHandler);
        }
    }
}

