/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.cache;

import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.cache.LruCache;
import java.util.Collections;
import java.util.List;

public class PreparedStatementCache {
    private final LruCache<String, PreparedStatement> cache;

    public PreparedStatementCache(int cacheCapacity) {
        this.cache = new LruCache(cacheCapacity);
    }

    public PreparedStatement get(String sql) {
        return (PreparedStatement)this.cache.get(sql);
    }

    public List<PreparedStatement> put(PreparedStatement preparedStatement) {
        this.cache.put(preparedStatement.sql(), preparedStatement);
        if (this.cache.removed != null) {
            List<PreparedStatement> evicted = this.cache.removed;
            this.cache.removed = null;
            return evicted;
        }
        return Collections.emptyList();
    }

    public void remove(String sql) {
        this.cache.remove(sql);
    }
}

