/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.sqlclient.impl.command.CommandBase;

public abstract class CommandResponse<R>
implements AsyncResult<R> {
    public CommandBase<R> cmd;
    private final AsyncResult<R> res;

    public static <R> CommandResponse<R> failure(String msg) {
        return CommandResponse.failure((Throwable)new NoStackTraceThrowable(msg));
    }

    public static <R> CommandResponse<R> failure(final Throwable cause) {
        return new CommandResponse<R>((AsyncResult)Future.failedFuture((Throwable)cause)){

            public R result() {
                return null;
            }

            public Throwable cause() {
                return cause;
            }

            public boolean succeeded() {
                return false;
            }

            public boolean failed() {
                return true;
            }
        };
    }

    public static <R> CommandResponse<R> success(final R result) {
        return new CommandResponse<R>((AsyncResult)Future.succeededFuture(result)){

            public R result() {
                return result;
            }

            public Throwable cause() {
                return null;
            }

            public boolean succeeded() {
                return true;
            }

            public boolean failed() {
                return false;
            }
        };
    }

    public CommandResponse(AsyncResult<R> res) {
        this.res = res;
    }

    public AsyncResult<R> toAsyncResult() {
        return this.res;
    }
}

