/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp.impl.protocol;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;
import java.nio.charset.Charset;

public class FrameHelper {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    private FrameHelper() {
    }

    public static void sendFrame(String type, String address, String replyAddress, JsonObject headers, Boolean send, JsonObject body, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", (Object)type);
        if (address != null) {
            payload.put("address", (Object)address);
        }
        if (replyAddress != null) {
            payload.put("replyAddress", (Object)replyAddress);
        }
        if (headers != null) {
            payload.put("headers", (Object)headers);
        }
        if (body != null) {
            payload.put("body", (Object)body);
        }
        if (send != null) {
            payload.put("send", (Object)send);
        }
        FrameHelper.writeFrame(payload, handler);
    }

    public static void sendFrame(String type, String address, String replyAddress, JsonObject body, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, address, replyAddress, null, null, body, handler);
    }

    public static void sendFrame(String type, String address, JsonObject body, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, address, null, null, null, body, handler);
    }

    public static void sendFrame(String type, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, null, null, null, null, null, handler);
    }

    public static void sendErrFrame(String address, String replyAddress, ReplyException failure, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", (Object)"err").put("address", (Object)replyAddress).put("sourceAddress", (Object)address).put("failureCode", (Object)failure.failureCode()).put("failureType", (Object)failure.failureType().name()).put("message", (Object)failure.getMessage());
        FrameHelper.writeFrame(payload, handler);
    }

    public static void sendErrFrame(String message, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", (Object)"err").put("message", (Object)message);
        FrameHelper.writeFrame(payload, handler);
    }

    public static void writeFrame(JsonObject payload, WriteStream<Buffer> handler) {
        byte[] data = payload.encode().getBytes(UTF8);
        handler.write((Object)Buffer.buffer().appendInt(data.length).appendBytes(data));
    }
}

