/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.util.RefUtils;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.contract.impl.HTTPOperationRequestValidationHandlerImpl;
import io.vertx.ext.web.api.contract.openapi3.OpenAPI3RequestValidationHandler;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import io.vertx.ext.web.api.validation.ContainerSerializationStyle;
import io.vertx.ext.web.api.validation.CustomValidator;
import io.vertx.ext.web.api.validation.ParameterLocation;
import io.vertx.ext.web.api.validation.ParameterType;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.SpecFeatureNotSupportedException;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.AnyOfTypeValidator;
import io.vertx.ext.web.api.validation.impl.ArrayTypeValidator;
import io.vertx.ext.web.api.validation.impl.ExpandedObjectFieldValidator;
import io.vertx.ext.web.api.validation.impl.JsonTypeValidator;
import io.vertx.ext.web.api.validation.impl.ObjectTypeValidator;
import io.vertx.ext.web.api.validation.impl.OneOfTypeValidator;
import io.vertx.ext.web.api.validation.impl.ParameterValidationRuleImpl;
import io.vertx.ext.web.impl.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OpenAPI3RequestValidationHandlerImpl
extends HTTPOperationRequestValidationHandlerImpl<Operation>
implements OpenAPI3RequestValidationHandler {
    private static final ParameterTypeValidator CONTENT_TYPE_VALIDATOR = new ParameterTypeValidator(){

        @Override
        public RequestParameter isValid(String value) throws ValidationException {
            return RequestParameter.create(value);
        }

        @Override
        public RequestParameter isValidCollection(List<String> value) throws ValidationException {
            if (value.size() > 1) {
                return RequestParameter.create(value);
            }
            return this.isValid(value.get(0));
        }
    };
    List<Parameter> resolvedParameters;
    OpenAPI spec;
    ResolverCache refsCache;

    public OpenAPI3RequestValidationHandlerImpl(Operation pathSpec, List<Parameter> resolvedParameters, OpenAPI spec, ResolverCache refsCache) {
        super(pathSpec);
        this.resolvedParameters = resolvedParameters;
        this.spec = spec;
        this.refsCache = refsCache;
        this.parseOperationSpec();
    }

    @Override
    public void parseOperationSpec() {
        RequestBody body;
        if (this.resolvedParameters != null) {
            for (Parameter opParameter : this.resolvedParameters) {
                if (opParameter.get$ref() != null) {
                    opParameter = (Parameter)this.refsCache.loadRef(opParameter.get$ref(), RefUtils.computeRefFormat((String)opParameter.get$ref()), Parameter.class);
                }
                this.parseParameter(opParameter);
            }
        }
        if ((body = ((Operation)this.pathSpec).getRequestBody()) != null) {
            if (body.get$ref() != null) {
                body = (RequestBody)this.refsCache.loadRef(body.get$ref(), RefUtils.computeRefFormat((String)body.get$ref()), RequestBody.class);
            }
            this.parseRequestBody(body);
        }
    }

    private ParameterTypeValidator resolveInnerSchemaPrimitiveTypeValidator(Schema schema, boolean parseEnum) {
        if (schema == null) {
            return ParameterType.GENERIC_STRING.validationMethod();
        }
        if (parseEnum && schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            return ParameterTypeValidator.createEnumTypeValidatorWithInnerValidator(new ArrayList<Object>(schema.getEnum()), this.resolveInnerSchemaPrimitiveTypeValidator(schema, false));
        }
        switch (schema.getType()) {
            case "integer": {
                if (schema.getFormat() != null && schema.getFormat().equals("int64")) {
                    return ParameterTypeValidator.createLongTypeValidator(schema.getExclusiveMaximum(), schema.getMaximum() != null ? Double.valueOf(schema.getMaximum().doubleValue()) : null, schema.getExclusiveMinimum(), schema.getMinimum() != null ? Double.valueOf(schema.getMinimum().doubleValue()) : null, schema.getMultipleOf() != null ? Double.valueOf(schema.getMultipleOf().doubleValue()) : null, schema.getDefault() != null ? schema.getDefault().toString() : null);
                }
                return ParameterTypeValidator.createIntegerTypeValidator(schema.getExclusiveMaximum(), schema.getMaximum() != null ? Double.valueOf(schema.getMaximum().doubleValue()) : null, schema.getExclusiveMinimum(), schema.getMinimum() != null ? Double.valueOf(schema.getMinimum().doubleValue()) : null, schema.getMultipleOf() != null ? Double.valueOf(schema.getMultipleOf().doubleValue()) : null, schema.getDefault() != null ? schema.getDefault().toString() : null);
            }
            case "number": {
                if (schema.getFormat() != null && schema.getFormat().equals("float")) {
                    return ParameterTypeValidator.createFloatTypeValidator(schema.getExclusiveMaximum(), schema.getMaximum() != null ? Double.valueOf(schema.getMaximum().doubleValue()) : null, schema.getExclusiveMinimum(), schema.getMinimum() != null ? Double.valueOf(schema.getMinimum().doubleValue()) : null, schema.getMultipleOf() != null ? Double.valueOf(schema.getMultipleOf().doubleValue()) : null, schema.getDefault() != null ? schema.getDefault().toString() : null);
                }
                return ParameterTypeValidator.createDoubleTypeValidator(schema.getExclusiveMaximum(), schema.getMaximum() != null ? Double.valueOf(schema.getMaximum().doubleValue()) : null, schema.getExclusiveMinimum(), schema.getMinimum() != null ? Double.valueOf(schema.getMinimum().doubleValue()) : null, schema.getMultipleOf() != null ? Double.valueOf(schema.getMultipleOf().doubleValue()) : null, schema.getDefault() != null ? schema.getDefault().toString() : null);
            }
            case "boolean": {
                return ParameterTypeValidator.createBooleanTypeValidator(schema.getDefault());
            }
            case "string": {
                String regex = null;
                if (schema.getFormat() != null) {
                    switch (schema.getFormat()) {
                        case "binary": {
                            break;
                        }
                        case "byte": {
                            regex = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
                            break;
                        }
                        case "date": {
                            regex = "^\\d{4}-(?:0[0-9]|1[0-2])-[0-9]{2}$";
                            break;
                        }
                        case "date-time": {
                            regex = "^\\d{4}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01])T([01]\\d|2[0-3]):([0-5]\\d):([0-5]\\d|60)(\\.\\d+)?(Z|(\\+|-)([01]\\d|2[0-3]):([0-5]\\d))$";
                            break;
                        }
                        case "ipv4": {
                            regex = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
                            break;
                        }
                        case "ipv6": {
                            regex = "^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$";
                            break;
                        }
                        case "hostname": {
                            regex = "^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\\-]*[A-Za-z0-9])$";
                            break;
                        }
                        case "email": {
                            regex = "^(?:[\\w!#\\$%&'\\*\\+\\-/=\\?\\^`\\{\\|\\}~]+\\.)*[\\w!#\\$%&'\\*\\+\\-/=\\?\\^`\\{\\|\\}~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\\-](?!\\.)){0,61}[a-zA-Z0-9]?\\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\\[(?:(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\.){3}(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\]))$";
                            break;
                        }
                        case "uuid": {
                            regex = "^[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}$";
                            break;
                        }
                        default: {
                            throw new SpecFeatureNotSupportedException("format " + schema.getFormat() + " not supported");
                        }
                    }
                }
                return ParameterTypeValidator.createStringTypeValidator(regex != null ? regex : schema.getPattern(), schema.getMinLength(), schema.getMaxLength(), schema.getDefault());
            }
        }
        return ParameterType.GENERIC_STRING.validationMethod();
    }

    private void resolveObjectTypeFields(ObjectTypeValidator validator, Schema schema) {
        Map<String, OpenApi3Utils.ObjectField> parameters = OpenApi3Utils.solveObjectParameters(schema);
        for (Map.Entry<String, OpenApi3Utils.ObjectField> entry : parameters.entrySet()) {
            validator.addField(entry.getKey(), this.resolveInnerSchemaPrimitiveTypeValidator(entry.getValue().getSchema(), true), entry.getValue().isRequired());
        }
    }

    private List<ParameterTypeValidator> resolveTypeValidatorsForAnyOfOneOf(List<Schema> schemas, Parameter parent) {
        ArrayList<ParameterTypeValidator> result = new ArrayList<ParameterTypeValidator>();
        for (Schema schema : schemas) {
            result.add(this.resolveAnyOfOneOfTypeValidator(schema, parent));
        }
        return result;
    }

    private ParameterTypeValidator resolveAnyOfOneOfTypeValidator(Schema schema, Parameter parent) {
        if (schema.getType().equals("array")) {
            return ArrayTypeValidator.ArrayTypeValidatorFactory.createArrayTypeValidator(this.resolveInnerSchemaPrimitiveTypeValidator(schema, true), OpenApi3Utils.resolveStyle(parent), (Boolean)OpenApi3Utils.safeBoolean.apply(parent.getExplode()), schema.getMaxItems(), schema.getMinItems());
        }
        if (schema.getType().equals("object")) {
            ObjectTypeValidator objectTypeValidator = ObjectTypeValidator.ObjectTypeValidatorFactory.createObjectTypeValidator(OpenApi3Utils.resolveStyle(parent), (boolean)((Boolean)OpenApi3Utils.safeBoolean.apply(parent.getExplode())));
            this.resolveObjectTypeFields(objectTypeValidator, schema);
            return objectTypeValidator;
        }
        return this.resolveInnerSchemaPrimitiveTypeValidator(schema, true);
    }

    private ParameterTypeValidator resolveAnyOfOneOfTypeValidator(Parameter parameter) {
        if (!(parameter.getSchema() instanceof ComposedSchema)) {
            return null;
        }
        ComposedSchema composedSchema = (ComposedSchema)parameter.getSchema();
        if (OpenApi3Utils.isAnyOfSchema((Schema)composedSchema)) {
            return new AnyOfTypeValidator(this.resolveTypeValidatorsForAnyOfOneOf(new ArrayList<Schema>(composedSchema.getAnyOf()), parameter));
        }
        if (OpenApi3Utils.isOneOfSchema((Schema)composedSchema)) {
            return new OneOfTypeValidator(this.resolveTypeValidatorsForAnyOfOneOf(new ArrayList<Schema>(composedSchema.getOneOf()), parameter));
        }
        return null;
    }

    private ParameterTypeValidator resolveTypeValidator(Parameter parameter) {
        ParameterTypeValidator candidate = this.resolveAnyOfOneOfTypeValidator(parameter);
        if (candidate != null) {
            return candidate;
        }
        if (OpenApi3Utils.isParameterArrayType(parameter)) {
            ArraySchema arraySchema = (ArraySchema)parameter.getSchema();
            return ArrayTypeValidator.ArrayTypeValidatorFactory.createArrayTypeValidator(this.resolveInnerSchemaPrimitiveTypeValidator(arraySchema.getItems(), true), OpenApi3Utils.resolveStyle(parameter), (Boolean)OpenApi3Utils.safeBoolean.apply(parameter.getExplode()), parameter.getSchema().getMaxItems(), parameter.getSchema().getMinItems());
        }
        if (OpenApi3Utils.isParameterObjectOrAllOfType(parameter)) {
            ObjectTypeValidator objectTypeValidator = ObjectTypeValidator.ObjectTypeValidatorFactory.createObjectTypeValidator(OpenApi3Utils.resolveStyle(parameter), (boolean)((Boolean)OpenApi3Utils.safeBoolean.apply(parameter.getExplode())));
            this.resolveObjectTypeFields(objectTypeValidator, parameter.getSchema());
            return objectTypeValidator;
        }
        return this.resolveInnerSchemaPrimitiveTypeValidator(parameter.getSchema(), true);
    }

    private void handleContent(Parameter parameter) {
        Content contents = parameter.getContent();
        ParameterLocation location = this.resolveLocation(parameter.getIn());
        List<MediaType> jsonsContents = OpenApi3Utils.extractTypesFromMediaTypesMap((Map<String, MediaType>)contents, Utils::isJsonContentType);
        if (jsonsContents.size() == 1) {
            this.addRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameter.getName(), JsonTypeValidator.JsonTypeValidatorFactory.createJsonTypeValidator(OpenApi3Utils.generateSanitizedJsonSchemaNode(jsonsContents.get(0).getSchema(), this.spec)), !OpenApi3Utils.isRequiredParam(parameter), OpenApi3Utils.resolveAllowEmptyValue(parameter), location), location);
        } else if (contents.size() > 1 && !jsonsContents.isEmpty()) {
            List<ParameterTypeValidator> validators = jsonsContents.stream().map(e -> JsonTypeValidator.JsonTypeValidatorFactory.createJsonTypeValidator(OpenApi3Utils.generateSanitizedJsonSchemaNode(e.getSchema(), this.spec))).collect(Collectors.toList());
            validators.add(CONTENT_TYPE_VALIDATOR);
            AnyOfTypeValidator validator = new AnyOfTypeValidator(validators);
            this.addRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameter.getName(), validator, !OpenApi3Utils.isRequiredParam(parameter), OpenApi3Utils.resolveAllowEmptyValue(parameter), location), location);
        } else {
            this.addRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameter.getName(), CONTENT_TYPE_VALIDATOR, !OpenApi3Utils.isRequiredParam(parameter), OpenApi3Utils.resolveAllowEmptyValue(parameter), location), location);
        }
    }

    private void magicParameterExplodedMatrixArray(Parameter parameter) {
        ArrayTypeValidator validator = ArrayTypeValidator.ArrayTypeValidatorFactory.createArrayTypeValidator(this.resolveInnerSchemaPrimitiveTypeValidator(((ArraySchema)parameter.getSchema()).getItems(), true), "matrix_exploded_array", true, parameter.getSchema().getMaxItems(), parameter.getSchema().getMinItems());
        this.addPathParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameter.getName(), validator, OpenApi3Utils.isRequiredParam(parameter), false, ParameterLocation.PATH));
    }

    private void magicParameterExplodedObject(Parameter parameter) {
        Map<String, OpenApi3Utils.ObjectField> properties = OpenApi3Utils.solveObjectParameters(parameter.getSchema());
        for (Map.Entry<String, OpenApi3Utils.ObjectField> entry : properties.entrySet()) {
            if ("query".equals(parameter.getIn())) {
                this.addQueryParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(entry.getKey(), new ExpandedObjectFieldValidator(this.resolveInnerSchemaPrimitiveTypeValidator(entry.getValue().getSchema(), true), parameter.getName(), entry.getKey()), !entry.getValue().isRequired(), OpenApi3Utils.resolveAllowEmptyValue(parameter), ParameterLocation.QUERY));
                continue;
            }
            if ("cookie".equals(parameter.getIn())) {
                this.addCookieParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(entry.getKey(), new ExpandedObjectFieldValidator(this.resolveInnerSchemaPrimitiveTypeValidator(entry.getValue().getSchema(), true), parameter.getName(), entry.getKey()), !entry.getValue().isRequired(), false, ParameterLocation.COOKIE));
                continue;
            }
            if ("path".equals(parameter.getIn())) {
                this.addPathParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(entry.getKey(), new ExpandedObjectFieldValidator(this.resolveInnerSchemaPrimitiveTypeValidator(entry.getValue().getSchema(), true), parameter.getName(), entry.getKey()), !entry.getValue().isRequired(), false, ParameterLocation.PATH));
                continue;
            }
            throw new SpecFeatureNotSupportedException("combination of style, type and location (in) of parameter fields not supported for parameter " + parameter.getName());
        }
        if (parameter.getSchema().getAdditionalProperties() instanceof Schema) {
            if ("query".equals(parameter.getIn())) {
                this.setQueryAdditionalPropertyHandler(this.resolveInnerSchemaPrimitiveTypeValidator((Schema)parameter.getSchema().getAdditionalProperties(), true), parameter.getName());
            } else if ("cookie".equals(parameter.getIn())) {
                this.setCookieAdditionalPropertyHandler(this.resolveInnerSchemaPrimitiveTypeValidator((Schema)parameter.getSchema().getAdditionalProperties(), true), parameter.getName());
            } else {
                throw new SpecFeatureNotSupportedException("additionalProperties with exploded object fields not supports in path parameter " + parameter.getName());
            }
        }
    }

    private void magicParameterExplodedStyleSimpleTypeObject(Parameter parameter) {
        ObjectTypeValidator objectTypeValidator = ObjectTypeValidator.ObjectTypeValidatorFactory.createObjectTypeValidator(ContainerSerializationStyle.simple_exploded_object, false);
        this.resolveObjectTypeFields(objectTypeValidator, parameter.getSchema());
        switch (parameter.getIn()) {
            case "path": {
                this.addPathParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameter.getName(), objectTypeValidator, !OpenApi3Utils.isRequiredParam(parameter), OpenApi3Utils.resolveAllowEmptyValue(parameter), ParameterLocation.PATH));
                break;
            }
            case "header": {
                this.addHeaderParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameter.getName(), objectTypeValidator, !OpenApi3Utils.isRequiredParam(parameter), OpenApi3Utils.resolveAllowEmptyValue(parameter), ParameterLocation.HEADER));
                break;
            }
            default: {
                throw new SpecFeatureNotSupportedException("combination of style, type and location (in) of parameter fields not supported for parameter " + parameter.getName());
            }
        }
    }

    private void magicParameterExplodedStyleDeepObjectTypeObject(Parameter parameter) {
        Map<String, OpenApi3Utils.ObjectField> properties = OpenApi3Utils.solveObjectParameters(parameter.getSchema());
        for (Map.Entry<String, OpenApi3Utils.ObjectField> entry : properties.entrySet()) {
            if (parameter.getIn().equals("query")) {
                this.addQueryParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameter.getName() + "[" + entry.getKey() + "]", new ExpandedObjectFieldValidator(this.resolveInnerSchemaPrimitiveTypeValidator(entry.getValue().getSchema(), true), parameter.getName(), entry.getKey()), !entry.getValue().isRequired(), OpenApi3Utils.resolveAllowEmptyValue(parameter), ParameterLocation.QUERY));
                continue;
            }
            throw new SpecFeatureNotSupportedException("combination of style, type and location (in) of parameter fields not supported for parameter " + parameter.getName());
        }
    }

    private boolean checkSupportedAndNeedWorkaround(Parameter parameter) {
        boolean result = false;
        if (Boolean.TRUE.equals(parameter.getAllowReserved())) {
            throw new SpecFeatureNotSupportedException("allowReserved field not supported!");
        }
        if (parameter.getContent() != null && parameter.getContent().size() != 0) {
            this.handleContent(parameter);
            result = true;
        } else if (Boolean.TRUE.equals(parameter.getExplode())) {
            boolean isObject = OpenApi3Utils.isParameterObjectOrAllOfType(parameter);
            String style = OpenApi3Utils.resolveStyle(parameter);
            if (OpenApi3Utils.isParameterArrayType(parameter) && "matrix".equals(style)) {
                this.magicParameterExplodedMatrixArray(parameter);
                result = true;
            }
            if (isObject && ("form".equals(style) || "matrix".equals(style) || "label".equals(style))) {
                this.magicParameterExplodedObject(parameter);
                result = true;
            }
            if (isObject && "simple".equals(style)) {
                this.magicParameterExplodedStyleSimpleTypeObject(parameter);
                result = true;
            } else if ("deepObject".equals(style)) {
                this.magicParameterExplodedStyleDeepObjectTypeObject(parameter);
                result = true;
            }
        }
        return result;
    }

    private ParameterLocation resolveLocation(String in) {
        switch (in) {
            case "header": {
                return ParameterLocation.HEADER;
            }
            case "query": {
                return ParameterLocation.QUERY;
            }
            case "cookie": {
                return ParameterLocation.COOKIE;
            }
            case "path": {
                return ParameterLocation.PATH;
            }
        }
        throw new SpecFeatureNotSupportedException("in field wrong or not supported");
    }

    private void parseParameter(Parameter parameter) {
        if (!this.checkSupportedAndNeedWorkaround(parameter)) {
            ParameterLocation location = this.resolveLocation(parameter.getIn());
            this.addRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameter.getName(), this.resolveTypeValidator(parameter), !OpenApi3Utils.isRequiredParam(parameter), OpenApi3Utils.resolveAllowEmptyValue(parameter), location), location);
        }
    }

    private ParameterTypeValidator resolveSchemaTypeValidatorFormEncoded(Schema schema) {
        if (schema.getType().equals("array")) {
            return ArrayTypeValidator.ArrayTypeValidatorFactory.createArrayTypeValidator(this.resolveInnerSchemaPrimitiveTypeValidator(((ArraySchema)schema).getItems(), true), "csv", false, schema.getMaxItems(), schema.getMinItems());
        }
        if (OpenApi3Utils.isSchemaObjectOrAllOfType(schema)) {
            ObjectTypeValidator objectTypeValidator = ObjectTypeValidator.ObjectTypeValidatorFactory.createObjectTypeValidator("csv", false);
            this.resolveObjectTypeFields(objectTypeValidator, schema);
            return objectTypeValidator;
        }
        return this.resolveInnerSchemaPrimitiveTypeValidator(schema, true);
    }

    private void handleMultimapParameter(String parameterName, String contentTypeRegex, Schema schema, Schema multipartObjectSchema) {
        if (contentTypeRegex == null) {
            if (OpenApi3Utils.isSchemaObjectOrAllOfType(schema) || OpenApi3Utils.isSchemaArray(schema) && OpenApi3Utils.isSchemaObjectOrAllOfType(((ArraySchema)schema).getItems())) {
                this.addFormParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameterName, JsonTypeValidator.JsonTypeValidatorFactory.createJsonTypeValidator(OpenApi3Utils.generateSanitizedJsonSchemaNode(schema, this.spec)), !OpenApi3Utils.isRequiredParam(multipartObjectSchema, parameterName), false, ParameterLocation.BODY_FORM));
            } else if (schema.getType().equals("string") && ("binary".equals(schema.getFormat()) || "base64".equals(schema.getFormat()))) {
                this.addCustomValidator(new MultipartCustomValidator(Pattern.compile(Pattern.quote("application/octet-stream")), parameterName, !OpenApi3Utils.isRequiredParam(multipartObjectSchema, parameterName)));
            } else {
                this.addFormParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator(parameterName, this.resolveSchemaTypeValidatorFormEncoded(schema), !OpenApi3Utils.isRequiredParam(multipartObjectSchema, parameterName), false, ParameterLocation.BODY_FORM));
            }
        } else {
            this.addCustomValidator(new MultipartCustomValidator(Pattern.compile(contentTypeRegex), parameterName, !OpenApi3Utils.isRequiredParam(multipartObjectSchema, parameterName)));
        }
    }

    private void parseRequestBody(RequestBody requestBody) {
        if (requestBody != null && requestBody.getContent() != null) {
            for (Map.Entry mediaType : requestBody.getContent().entrySet()) {
                if (Utils.isJsonContentType((String)((String)mediaType.getKey())) && ((MediaType)mediaType.getValue()).getSchema() != null) {
                    this.setEntireBodyValidator(JsonTypeValidator.JsonTypeValidatorFactory.createJsonTypeValidator(OpenApi3Utils.generateSanitizedJsonSchemaNode(((MediaType)mediaType.getValue()).getSchema(), this.spec)));
                    continue;
                }
                if (((String)mediaType.getKey()).equals("application/x-www-form-urlencoded") && ((MediaType)mediaType.getValue()).getSchema() != null) {
                    for (Map.Entry paramSchema : ((MediaType)mediaType.getValue()).getSchema().getProperties().entrySet()) {
                        this.addFormParamRule(ParameterValidationRuleImpl.ParameterValidationRuleFactory.createValidationRuleWithCustomTypeValidator((String)paramSchema.getKey(), this.resolveSchemaTypeValidatorFormEncoded((Schema)paramSchema.getValue()), !OpenApi3Utils.isRequiredParam(((MediaType)mediaType.getValue()).getSchema(), (String)paramSchema.getKey()), false, ParameterLocation.BODY_FORM));
                    }
                    continue;
                }
                if (((String)mediaType.getKey()).equals("multipart/form-data") && ((MediaType)mediaType.getValue()).getSchema() != null && ((MediaType)mediaType.getValue()).getSchema().getType().equals("object")) {
                    for (Map.Entry multipartProperty : ((MediaType)mediaType.getValue()).getSchema().getProperties().entrySet()) {
                        Encoding encodingProperty = null;
                        if (((MediaType)mediaType.getValue()).getEncoding() != null) {
                            encodingProperty = (Encoding)((MediaType)mediaType.getValue()).getEncoding().get(multipartProperty.getKey());
                        }
                        String contentTypeRegex = null;
                        if (encodingProperty != null && encodingProperty.getContentType() != null) {
                            contentTypeRegex = OpenApi3Utils.resolveContentTypeRegex(encodingProperty.getContentType());
                        }
                        this.handleMultimapParameter((String)multipartProperty.getKey(), contentTypeRegex, (Schema)multipartProperty.getValue(), ((MediaType)mediaType.getValue()).getSchema());
                    }
                    continue;
                }
                this.addBodyFileRule((String)mediaType.getKey());
            }
            this.bodyRequired = (Boolean)OpenApi3Utils.safeBoolean.apply(requestBody.getRequired());
        }
    }

    private static class MultipartCustomValidator
    implements CustomValidator {
        Pattern contentTypePattern;
        String parameterName;
        boolean isOptional;

        public MultipartCustomValidator(Pattern contentTypeRegex, String parameterName, boolean isOptional) {
            this.contentTypePattern = contentTypeRegex;
            this.parameterName = parameterName;
            this.isOptional = isOptional;
        }

        private boolean existFileUpload(List<FileUpload> files, String name, Pattern contentType) {
            for (FileUpload f : files) {
                if (!f.name().equals(name) || !contentType.matcher(f.contentType()).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void validate(RoutingContext routingContext) throws ValidationException {
            if (!(this.existFileUpload(routingContext.fileUploads(), this.parameterName, this.contentTypePattern) || routingContext.request().formAttributes().contains(this.parameterName) || this.isOptional)) {
                throw ValidationException.ValidationExceptionFactory.generateNotFoundValidationException(this.parameterName, ParameterLocation.BODY_FORM);
            }
        }
    }
}

